/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.airline.help;

import com.google.common.base.Preconditions;
import io.airlift.airline.help.AbstractCommandGroupUsageGenerator;
import io.airlift.airline.help.UsagePrinter;
import io.airlift.airline.model.CommandGroupMetadata;
import io.airlift.airline.model.CommandMetadata;
import io.airlift.airline.model.GlobalMetadata;
import io.airlift.airline.model.OptionMetadata;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Comparator;
import javax.annotation.Nullable;

public abstract class AbstractPrintedCommandGroupUsageGenerator
extends AbstractCommandGroupUsageGenerator {
    private final int columnSize;

    public AbstractPrintedCommandGroupUsageGenerator(int columnSize, @Nullable Comparator<? super OptionMetadata> optionComparator, @Nullable Comparator<? super CommandMetadata> commandComparator) {
        super(optionComparator, commandComparator);
        Preconditions.checkArgument((columnSize > 0 ? 1 : 0) != 0, (Object)"columnSize must be greater than 0");
        this.columnSize = columnSize;
    }

    protected abstract void usage(GlobalMetadata var1, CommandGroupMetadata var2, UsagePrinter var3) throws IOException;

    protected UsagePrinter createUsagePrinter(OutputStream out) {
        Preconditions.checkNotNull((Object)out, (Object)"StringBuilder cannot be null");
        return new UsagePrinter(new OutputStreamWriter(out), this.columnSize);
    }

    @Override
    public void usage(GlobalMetadata global, CommandGroupMetadata group, OutputStream out) throws IOException {
        UsagePrinter printer = this.createUsagePrinter(out);
        this.usage(global, group, printer);
        printer.flush();
    }
}

