/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.airline.help;

import com.google.common.base.Preconditions;
import io.airlift.airline.help.AbstractCommandUsageGenerator;
import io.airlift.airline.help.UsagePrinter;
import io.airlift.airline.model.CommandMetadata;
import io.airlift.airline.model.OptionMetadata;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Comparator;
import javax.annotation.Nullable;

public abstract class AbstractPrintedCommandUsageGenerator
extends AbstractCommandUsageGenerator {
    private final int columnSize;

    public AbstractPrintedCommandUsageGenerator(int columnSize, @Nullable Comparator<? super OptionMetadata> optionComparator) {
        super(optionComparator);
        Preconditions.checkArgument((columnSize > 0 ? 1 : 0) != 0, (Object)"columnSize must be greater than 0");
        this.columnSize = columnSize;
    }

    protected abstract void usage(@Nullable String var1, @Nullable String var2, String var3, CommandMetadata var4, UsagePrinter var5) throws IOException;

    protected UsagePrinter createUsagePrinter(OutputStream out) {
        Preconditions.checkNotNull((Object)out, (Object)"OutputStream cannot be null");
        OutputStreamWriter writer = new OutputStreamWriter(out);
        return new UsagePrinter(writer, this.columnSize);
    }

    @Override
    public void usage(@Nullable String programName, @Nullable String groupName, String commandName, CommandMetadata command, OutputStream out) throws IOException {
        UsagePrinter printer = this.createUsagePrinter(out);
        this.usage(programName, groupName, commandName, command, printer);
        printer.flush();
    }
}

