/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.airline.help.cli;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.airlift.airline.help.AbstractPrintedCommandGroupUsageGenerator;
import io.airlift.airline.help.UsageHelper;
import io.airlift.airline.help.UsagePrinter;
import io.airlift.airline.model.CommandGroupMetadata;
import io.airlift.airline.model.CommandMetadata;
import io.airlift.airline.model.GlobalMetadata;
import io.airlift.airline.model.OptionMetadata;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeMap;
import javax.annotation.Nullable;

public class CliCommandGroupUsageGenerator
extends AbstractPrintedCommandGroupUsageGenerator {
    private final boolean hideGlobalOptions;

    public CliCommandGroupUsageGenerator() {
        this(79, false, UsageHelper.DEFAULT_OPTION_COMPARATOR, UsageHelper.DEFAULT_COMMAND_COMPARATOR);
    }

    public CliCommandGroupUsageGenerator(int columnSize) {
        this(columnSize, false, UsageHelper.DEFAULT_OPTION_COMPARATOR, UsageHelper.DEFAULT_COMMAND_COMPARATOR);
    }

    public CliCommandGroupUsageGenerator(int columnSize, boolean hideGlobalOptions) {
        this(columnSize, hideGlobalOptions, UsageHelper.DEFAULT_OPTION_COMPARATOR, UsageHelper.DEFAULT_COMMAND_COMPARATOR);
    }

    public CliCommandGroupUsageGenerator(int columnSize, boolean hideGlobalOptions, @Nullable Comparator<? super OptionMetadata> optionComparator, @Nullable Comparator<? super CommandMetadata> commandComparator) {
        super(columnSize, optionComparator, commandComparator);
        this.hideGlobalOptions = hideGlobalOptions;
    }

    @Override
    protected void usage(@Nullable GlobalMetadata global, CommandGroupMetadata group, UsagePrinter out) throws IOException {
        out.append("NAME").newline();
        out.newIndentedPrinter(8).append(global.getName()).append(group.getName()).append("-").append(group.getDescription()).newline().newline();
        out.append("SYNOPSIS").newline();
        UsagePrinter synopsis = out.newIndentedPrinter(8).newPrinterWithHangingIndent(8);
        List<CommandMetadata> commands = this.sortCommands(group.getCommands());
        String defaultCommand = "";
        if (group.getDefaultCommand() != null) {
            defaultCommand = group.getDefaultCommand().getName();
        }
        ArrayList commonGroupOptions = null;
        String commonGroupArgs = null;
        ArrayList allCommandNames = Lists.newArrayList();
        boolean hasCommandSpecificOptions = false;
        boolean hasCommandSpecificArgs = false;
        for (CommandMetadata command : commands) {
            if (command.getName().equals(defaultCommand)) {
                allCommandNames.add(command.getName() + "*");
            } else {
                allCommandNames.add(command.getName());
            }
            if (commonGroupOptions == null) {
                commonGroupOptions = Lists.newArrayList(command.getCommandOptions());
            }
            if (commonGroupArgs == null) {
                commonGroupArgs = command.getArguments() != null ? this.toUsage(command.getArguments()) : "";
            }
            commonGroupOptions.retainAll(command.getCommandOptions());
            if (command.getCommandOptions().size() > commonGroupOptions.size()) {
                hasCommandSpecificOptions = true;
            }
            if (commonGroupArgs == (command.getArguments() != null ? this.toUsage(command.getArguments()) : "")) continue;
            hasCommandSpecificArgs = true;
        }
        if (global != null) {
            synopsis.append(global.getName());
            if (!this.hideGlobalOptions) {
                synopsis.appendWords(this.toSynopsisUsage(commands.get(0).getGlobalOptions()));
            }
        }
        synopsis.append(group.getName()).appendWords(this.toSynopsisUsage(commands.get(0).getGroupOptions()));
        synopsis.append(" {").append((String)allCommandNames.get(0));
        for (int i = 1; i < allCommandNames.size(); ++i) {
            synopsis.append(" | ").append((String)allCommandNames.get(i));
        }
        synopsis.append("} [--]");
        if (commonGroupOptions.size() > 0) {
            synopsis.appendWords(this.toSynopsisUsage(commonGroupOptions));
        }
        if (hasCommandSpecificOptions) {
            synopsis.append(" [cmd-options]");
        }
        if (hasCommandSpecificArgs) {
            synopsis.append(" <cmd-args>");
        }
        synopsis.newline();
        TreeMap cmdOptions = Maps.newTreeMap();
        TreeMap cmdArguments = Maps.newTreeMap();
        for (CommandMetadata command : commands) {
            if (command.isHidden()) continue;
            if (hasCommandSpecificOptions) {
                ArrayList arrayList = Lists.newArrayList(command.getCommandOptions());
                arrayList.removeAll(commonGroupOptions);
                StringBuilder optSB = new StringBuilder();
                for (String s : this.toSynopsisUsage(arrayList)) {
                    optSB.append(s + " ");
                }
                cmdOptions.put(command.getName(), optSB.toString());
            }
            if (!hasCommandSpecificArgs) continue;
            cmdArguments.put(command.getName(), command.getArguments() != null ? this.toUsage(command.getArguments()) : "");
        }
        if (hasCommandSpecificOptions) {
            synopsis.newline().append("Where command-specific options [cmd-options] are:").newline();
            UsagePrinter opts = synopsis.newIndentedPrinter(4);
            for (String string : cmdOptions.keySet()) {
                opts.append(string + ": " + (String)cmdOptions.get(string)).newline();
            }
        }
        if (hasCommandSpecificArgs) {
            synopsis.newline().append("Where command-specific arguments <cmd-args> are:").newline();
            UsagePrinter args = synopsis.newIndentedPrinter(4);
            for (String string : cmdArguments.keySet()) {
                args.append(string + ": " + (String)cmdArguments.get(string)).newline();
            }
        }
        if (defaultCommand != "") {
            synopsis.newline().append(String.format("* %s is the default command", defaultCommand));
        }
        synopsis.newline().append("See").append("'" + global.getName()).append("help ").append(group.getName()).appendOnOneLine(" <command>' for more information on a specific command.").newline();
        List<Object> options = Lists.newArrayList();
        options.addAll(group.getOptions());
        if (global != null && !this.hideGlobalOptions) {
            options.addAll(global.getOptions());
        }
        if (options.size() > 0) {
            options = this.sortOptions((List<OptionMetadata>)options);
            out.append("OPTIONS").newline();
            for (OptionMetadata optionMetadata : options) {
                if (optionMetadata.isHidden()) continue;
                UsagePrinter optionPrinter = out.newIndentedPrinter(8);
                optionPrinter.append(this.toDescription(optionMetadata)).newline();
                UsagePrinter descriptionPrinter = optionPrinter.newIndentedPrinter(4);
                descriptionPrinter.append(optionMetadata.getDescription()).newline();
                descriptionPrinter.newline();
            }
        }
    }
}

