/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.airline.help.cli;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.airlift.airline.help.AbstractPrintedCommandUsageGenerator;
import io.airlift.airline.help.UsageHelper;
import io.airlift.airline.help.UsagePrinter;
import io.airlift.airline.model.ArgumentsMetadata;
import io.airlift.airline.model.CommandMetadata;
import io.airlift.airline.model.OptionMetadata;
import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;

public class CliCommandUsageGenerator
extends AbstractPrintedCommandUsageGenerator {
    public CliCommandUsageGenerator() {
        this(79, UsageHelper.DEFAULT_OPTION_COMPARATOR);
    }

    public CliCommandUsageGenerator(int columnSize) {
        this(columnSize, UsageHelper.DEFAULT_OPTION_COMPARATOR);
    }

    public CliCommandUsageGenerator(int columnSize, @Nullable Comparator<? super OptionMetadata> optionComparator) {
        super(columnSize, optionComparator);
    }

    @Override
    protected void usage(@Nullable String programName, @Nullable String groupName, String commandName, CommandMetadata command, UsagePrinter out) throws IOException {
        out.append("NAME").newline();
        out.newIndentedPrinter(8).append(programName).append(groupName).append(commandName).append("-").append(command.getDescription()).newline().newline();
        out.append("SYNOPSIS").newline();
        UsagePrinter synopsis = out.newIndentedPrinter(8).newPrinterWithHangingIndent(8);
        List<Object> options = Lists.newArrayList();
        if (programName != null) {
            synopsis.append(programName).appendWords(this.toSynopsisUsage(this.sortOptions(command.getGlobalOptions())));
            options.addAll(command.getGlobalOptions());
        }
        if (groupName != null) {
            synopsis.append(groupName).appendWords(this.toSynopsisUsage(this.sortOptions(command.getGroupOptions())));
            options.addAll(command.getGroupOptions());
        }
        synopsis.append(commandName).appendWords(this.toSynopsisUsage(this.sortOptions(command.getCommandOptions())));
        options.addAll(command.getCommandOptions());
        ArgumentsMetadata arguments = command.getArguments();
        if (arguments != null) {
            synopsis.append("[--]").append(this.toUsage(arguments));
        }
        synopsis.newline();
        synopsis.newline();
        if (options.size() > 0 || arguments != null) {
            options = this.sortOptions((List<OptionMetadata>)options);
            out.append("OPTIONS").newline();
            for (OptionMetadata optionMetadata : options) {
                if (optionMetadata.isHidden()) continue;
                UsagePrinter optionPrinter = out.newIndentedPrinter(8);
                optionPrinter.append(this.toDescription(optionMetadata)).newline();
                UsagePrinter descriptionPrinter = optionPrinter.newIndentedPrinter(4);
                descriptionPrinter.append(optionMetadata.getDescription()).newline();
                descriptionPrinter.newline();
            }
            if (arguments != null) {
                UsagePrinter optionPrinter = out.newIndentedPrinter(8);
                optionPrinter.append("--").newline();
                UsagePrinter usagePrinter = optionPrinter.newIndentedPrinter(4);
                usagePrinter.append("This option can be used to separate command-line options from the list of argument, (useful when arguments might be mistaken for command-line options").newline();
                usagePrinter.newline();
                optionPrinter.append(this.toDescription(arguments)).newline();
                usagePrinter.append(arguments.getDescription()).newline();
                usagePrinter.newline();
            }
        }
        if (command.getDiscussion() != null) {
            out.append("DISCUSSION").newline();
            UsagePrinter disc = out.newIndentedPrinter(8);
            disc.append(command.getDiscussion()).newline().newline();
        }
        if (command.getExamples() != null && !command.getExamples().isEmpty()) {
            out.append("EXAMPLES").newline();
            UsagePrinter ex = out.newIndentedPrinter(8);
            ex.appendTable(Iterables.partition(command.getExamples(), (int)1));
        }
    }
}

