/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.airline.help.cli;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.airlift.airline.help.AbstractPrintedGlobalUsageGenerator;
import io.airlift.airline.help.UsageHelper;
import io.airlift.airline.help.UsagePrinter;
import io.airlift.airline.model.CommandGroupMetadata;
import io.airlift.airline.model.CommandMetadata;
import io.airlift.airline.model.GlobalMetadata;
import io.airlift.airline.model.OptionMetadata;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nullable;

public class CliGlobalUsageSummaryGenerator
extends AbstractPrintedGlobalUsageGenerator {
    public CliGlobalUsageSummaryGenerator() {
        this(79);
    }

    public CliGlobalUsageSummaryGenerator(int columnSize) {
        this(columnSize, UsageHelper.DEFAULT_OPTION_COMPARATOR, UsageHelper.DEFAULT_COMMAND_COMPARATOR);
    }

    public CliGlobalUsageSummaryGenerator(int columnSize, @Nullable Comparator<? super OptionMetadata> optionComparator, @Nullable Comparator<? super CommandMetadata> commandComparator) {
        super(columnSize, optionComparator, commandComparator);
    }

    @Override
    public void usage(GlobalMetadata global, UsagePrinter out) throws IOException {
        ArrayList commandArguments = Lists.newArrayList();
        Collection args = Collections2.transform(global.getOptions(), (Function)new Function<OptionMetadata, String>(){

            public String apply(OptionMetadata option) {
                if (option.isHidden()) {
                    return "";
                }
                return CliGlobalUsageSummaryGenerator.this.toUsage(option);
            }
        });
        commandArguments.addAll(args);
        out.newPrinterWithHangingIndent(8).append("usage:").append(global.getName()).appendWords(commandArguments).append("<command> [ <args> ]").newline().newline();
        TreeMap commands = Maps.newTreeMap();
        for (CommandMetadata commandMetadata : global.getDefaultGroupCommands()) {
            if (commandMetadata.isHidden()) continue;
            commands.put(commandMetadata.getName(), commandMetadata.getDescription());
        }
        for (CommandGroupMetadata commandGroupMetadata : global.getCommandGroups()) {
            commands.put(commandGroupMetadata.getName(), commandGroupMetadata.getDescription());
        }
        out.append("Commands are:").newline();
        out.newIndentedPrinter(4).appendTable(Iterables.transform(commands.entrySet(), (Function)new Function<Map.Entry<String, String>, Iterable<String>>(){

            public Iterable<String> apply(Map.Entry<String, String> entry) {
                return ImmutableList.of((Object)entry.getKey(), (Object)Objects.firstNonNull((Object)entry.getValue(), (Object)""));
            }
        }));
        out.newline();
        out.append("See").append("'" + global.getName()).append("help <command>' for more information on a specific command.").newline();
    }
}

