/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.airline.help.cli.bash;

import io.airlift.airline.help.AbstractGlobalUsageGenerator;
import io.airlift.airline.model.CommandGroupMetadata;
import io.airlift.airline.model.CommandMetadata;
import io.airlift.airline.model.GlobalMetadata;
import io.airlift.airline.model.OptionMetadata;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;

public class BashCompletionGenerator
extends AbstractGlobalUsageGenerator {
    private final boolean withDebugging;

    public BashCompletionGenerator() {
        this(false);
    }

    public BashCompletionGenerator(boolean enableDebugging) {
        this.withDebugging = enableDebugging;
    }

    @Override
    public void usage(GlobalMetadata global, OutputStream output) throws IOException {
        boolean hasGroups;
        OutputStreamWriter writer = new OutputStreamWriter(output);
        ((Writer)writer).append("#!/bin/bash").append("\n\n");
        ((Writer)writer).append("# Generated by airline BashCompletionGenerator").append("\n\n");
        ((Writer)writer).append("containsElement () {\n");
        ((Writer)writer).append("  # This function from http://stackoverflow.com/a/8574392/107591\n");
        ((Writer)writer).append("  local e\n");
        ((Writer)writer).append("  for e in \"${@:2}\"; do [[ \"$e\" == \"$1\" ]] && return 0; done\n");
        ((Writer)writer).append("  return 1\n");
        ((Writer)writer).append("}\n\n");
        boolean bl = hasGroups = global.getCommandGroups().size() > 1 || global.getDefaultGroupCommands().size() == 0;
        if (hasGroups) {
            for (CommandGroupMetadata group : global.getCommandGroups()) {
                this.generateGroupCompletionFunction(writer, global, group);
            }
        } else {
            for (CommandMetadata command : global.getDefaultGroupCommands()) {
                if (command.isHidden()) continue;
                this.generateCommandCompletionFunction(writer, global, command);
            }
        }
        ((Writer)writer).append("_complete_").append(this.bashize(global.getName())).append("() {").append('\n');
        if (this.withDebugging) {
            ((Writer)writer).append("  # Debugging Enabled").append('\n');
            ((Writer)writer).append("  set -o xtrace").append("\n\n");
        }
        ((Writer)writer).append("  # Get completion data").append('\n');
        ((Writer)writer).append("  CURR_WORD=${COMP_WORDS[COMP_CWORD]}").append('\n');
        ((Writer)writer).append("  PREV_WORD=${COMP_WORDS[COMP_CWORD-1]}").append('\n');
        ((Writer)writer).append("  CURR_CMD=").append('\n');
        ((Writer)writer).append("  if [[ ${COMP_CWORD} -ge 1 ]]; then").append('\n');
        ((Writer)writer).append("    CURR_CMD=${COMP_WORDS[1]}").append('\n');
        ((Writer)writer).append("  fi").append("\n\n");
        HashSet<String> commandNames = new HashSet<String>();
        for (CommandMetadata command : global.getDefaultGroupCommands()) {
            if (command.isHidden()) continue;
            commandNames.add(command.getName());
        }
        if (hasGroups) {
            for (CommandGroupMetadata group : global.getCommandGroups()) {
                commandNames.add(group.getName());
            }
        }
        this.writeWordListVariable(writer, 2, "COMMANDS", commandNames.iterator());
        ((Writer)writer).append("  if [[ ${COMP_CWORD} -eq 1 ]]; then").append('\n');
        ((Writer)writer).append("    COMPREPLY=()").append('\n');
        this.writeCompletionGeneration(writer, 4, false, 0, "COMMANDS");
        ((Writer)writer).append("  fi").append("\n\n");
        ((Writer)writer).append("  case ${CURR_CMD} in ").append('\n');
        if (hasGroups) {
            for (CommandGroupMetadata group : global.getCommandGroups()) {
                this.indent(writer, 4);
                ((Writer)writer).append(group.getName()).append(')').append('\n');
                this.indent(writer, 6);
                ((Writer)writer).append("$( _completion_group_").append(this.bashize(group.getName())).append(" )").append('\n');
                if (this.withDebugging) {
                    this.indent(writer, 6);
                    ((Writer)writer).append("set +o xtrace").append('\n');
                }
                this.indent(writer, 6);
                ((Writer)writer).append("return $?").append('\n');
                this.indent(writer, 6);
                ((Writer)writer).append(";;").append('\n');
            }
        } else {
            for (CommandMetadata command : global.getDefaultGroupCommands()) {
                if (command.isHidden()) continue;
                this.indent(writer, 4);
                ((Writer)writer).append(command.getName()).append(')').append('\n');
                this.indent(writer, 6);
                ((Writer)writer).append("COMPREPLY=( $( _completion_command_").append(this.bashize(command.getName())).append(" \"${COMMANDS}\" ) )").append('\n');
                if (this.withDebugging) {
                    this.indent(writer, 6);
                    ((Writer)writer).append("set +o xtrace").append('\n');
                }
                this.indent(writer, 6);
                ((Writer)writer).append("return $?").append('\n');
                this.indent(writer, 6);
                ((Writer)writer).append(";;").append('\n');
            }
        }
        ((Writer)writer).append("  esac").append("\n\n");
        if (this.withDebugging) {
            ((Writer)writer).append("  set +o xtrace").append('\n');
        }
        ((Writer)writer).append("}").append("\n\n");
        ((Writer)writer).append("complete -F _complete_").append(this.bashize(global.getName())).append(" ").append(global.getName());
        ((Writer)writer).flush();
        output.flush();
    }

    private void generateGroupCompletionFunction(Writer writer, GlobalMetadata global, CommandGroupMetadata group) throws IOException {
        writer.append("_completion_group_").append(this.bashize(group.getName())).append("() {").append('\n');
        if (this.withDebugging) {
            writer.append("  # Debugging Enabled").append('\n');
            writer.append("  set -o xtrace").append("\n\n");
        }
        writer.append("  # Get completion data").append('\n');
        writer.append("  COMPREPLY=()").append('\n');
        writer.append("  CURR_WORD=${COMP_WORDS[COMP_CWORD]}").append('\n');
        writer.append("  PREV_WORD=${COMP_WORDS[COMP_CWORD-1]}").append("\n");
        HashSet<String> commandNames = new HashSet<String>();
        for (CommandMetadata command : group.getCommands()) {
            if (command.isHidden()) continue;
            commandNames.add(command.getName());
        }
        this.writeWordListVariable(writer, 2, "COMMANDS", commandNames.iterator());
        writer.append("  if [[ ${COMP_CWORD} -eq 2 ]]; then").append('\n');
        this.writeCompletionGeneration(writer, 4, true, 0, "COMMANDS");
        writer.append("  fi");
        writer.append("  case ${CURR_CMD} in ");
        for (CommandMetadata command : group.getCommands()) {
            if (command.isHidden()) continue;
            this.indent(writer, 4);
            writer.append(command.getName()).append(')').append('\n');
            this.indent(writer, 6);
            writer.append("COMPREPLY=( $( _completion_command_").append(this.bashize(command.getName())).append(" \"${COMMANDS}\" ) )").append('\n');
            this.indent(writer, 6);
            writer.append("return $?").append('\n');
            this.indent(writer, 6);
            writer.append(";;");
        }
        if (this.withDebugging) {
            writer.append("  set +o xtrace").append('\n');
        }
        writer.append('}').append("\n\n");
    }

    private void generateCommandCompletionFunction(Writer writer, GlobalMetadata global, CommandMetadata command) throws IOException {
        writer.append("_completion_command_").append(this.bashize(command.getName())).append("() {").append('\n');
        if (this.withDebugging) {
            writer.append("  # Debugging Enabled").append('\n');
            writer.append("  set -o xtrace").append("\n\n");
        }
        writer.append("  # Get completion data").append('\n');
        writer.append("  COMPREPLY=()").append('\n');
        writer.append("  CURR_WORD=${COMP_WORDS[COMP_CWORD]}").append('\n');
        writer.append("  PREV_WORD=${COMP_WORDS[COMP_CWORD-1]}").append('\n');
        writer.append("  COMMANDS=$1").append("\n\n");
        HashSet<String> flagOpts = new HashSet<String>();
        HashSet<String> argOpts = new HashSet<String>();
        for (OptionMetadata option : command.getAllOptions()) {
            if (option.isHidden()) continue;
            if (option.getArity() == 0) {
                flagOpts.addAll(option.getOptions());
                continue;
            }
            argOpts.addAll(option.getOptions());
        }
        this.writeWordListVariable(writer, 2, "FLAG_OPTS", flagOpts.iterator());
        this.writeWordListVariable(writer, 2, "ARG_OPTS", argOpts.iterator());
        writer.append('\n');
        if (argOpts.size() > 0) {
            writer.append("  $( containsElement ${PREV_WORD} ${ARG_OPTS[@]} )").append('\n');
            writer.append("  SAW_ARG=$?").append('\n');
            writer.append("  if [[ ${SAW_ARG} -eq 0 ]]; then").append('\n');
            writer.append("    ARG_VALUES=").append('\n');
            writer.append("    ARG_GENERATED_VALUES=").append('\n');
            writer.append("    case ${PREV_WORD} in").append('\n');
            for (OptionMetadata option : command.getAllOptions()) {
                if (option.isHidden() || option.getArity() == 0) continue;
                this.indent(writer, 6);
                Iterator<String> names = option.getOptions().iterator();
                while (names.hasNext()) {
                    writer.append(names.next());
                    if (!names.hasNext()) continue;
                    writer.append('|');
                }
                writer.append(")\n");
                if (StringUtils.isNotEmpty((CharSequence)option.getCompletionCommand())) {
                    this.indent(writer, 8);
                    writer.append("ARG_GENERATED_VALUES=$( ").append(option.getCompletionCommand()).append(" )").append('\n');
                }
                if (option.getAllowedValues() != null && option.getAllowedValues().size() > 0) {
                    this.writeWordListVariable(writer, 8, "ARG_VALUES", option.getAllowedValues().iterator());
                }
                this.writeCompletionGeneration(writer, 8, true, option.getCompletionBehaviours(), "ARG_VALUES", "ARG_GENERATED_VALUES");
                this.indent(writer, 8);
                writer.append(";;").append('\n');
            }
            writer.append("    esac").append('\n');
            writer.append("  fi").append("\n\n");
        }
        int behaviour = 0;
        if (command.getArguments() != null) {
            if (StringUtils.isNotEmpty((CharSequence)command.getArguments().getCompletionCommand())) {
                writer.append("  ARGUMENTS=$( ").append(command.getArguments().getCompletionCommand()).append(" )").append('\n');
            } else {
                writer.append("  ARGUMENTS=").append('\n');
            }
            behaviour = command.getArguments().getCompletionBehaviours();
        } else {
            writer.append("  ARGUMENTS=").append('\n');
        }
        this.writeCompletionGeneration(writer, 2, true, behaviour, "FLAG_OPTS", "ARG_OPTS", "ARGUMENTS");
        if (this.withDebugging) {
            writer.append("  set +o xtrace").append('\n');
        }
        writer.append('}').append("\n\n");
    }

    private void indent(Writer writer, int indent) throws IOException {
        this.repeat(writer, indent, ' ');
    }

    private void repeat(Writer writer, int count, char c) throws IOException {
        if (count <= 0) {
            return;
        }
        for (int i = 0; i < count; ++i) {
            writer.append(c);
        }
    }

    private void writeWordListVariable(Writer writer, int indent, String varName, Iterator<String> words) throws IOException {
        this.indent(writer, indent);
        writer.append(varName).append("=\"");
        while (words.hasNext()) {
            writer.append(words.next());
            if (!words.hasNext()) continue;
            writer.append(' ');
        }
        writer.append('\"').append('\n');
    }

    private void writeCompletionGeneration(Writer writer, int indent, boolean isNestedFunction, int behaviour, String ... varNames) throws IOException {
        this.indent(writer, indent);
        writer.append("COMPREPLY=( $(compgen ");
        switch (behaviour) {
            case 1: {
                writer.append("-o default ");
                break;
            }
            case 2: {
                writer.append("-o dirnames ");
                break;
            }
            case 3: {
                writer.append("-o filenames ");
                break;
            }
            case 4: {
                writer.append("-o plusdirs ");
                break;
            }
            case 6: {
                writer.append("-c ");
            }
        }
        writer.append("-W \"");
        for (int i = 0; i < varNames.length; ++i) {
            writer.append("${").append(varNames[i]).append("}");
            if (i >= varNames.length - 1) continue;
            writer.append(' ');
        }
        if (behaviour == 5) {
            writer.append(" ${COMMANDS}");
        }
        writer.append("\" -- ${CURR_WORD}) )").append('\n');
        if (isNestedFunction) {
            this.indent(writer, indent);
            writer.append("echo ${COMPREPLY[@]}").append('\n');
        }
        if (this.withDebugging) {
            this.indent(writer, indent);
            writer.append("set +o xtrace").append('\n');
        }
        this.indent(writer, indent);
        writer.append("return 0").append('\n');
    }

    private String bashize(String value) {
        StringBuilder builder = new StringBuilder();
        for (char c : value.toCharArray()) {
            if (!Character.isLetterOrDigit(c) && c != '_') continue;
            builder.append(c);
        }
        return builder.toString();
    }
}

