/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.airline.help.ronn;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.airlift.airline.help.AbstractCommandUsageGenerator;
import io.airlift.airline.model.ArgumentsMetadata;
import io.airlift.airline.model.CommandMetadata;
import io.airlift.airline.model.OptionMetadata;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;

public class RonnCommandUsageGenerator
extends AbstractCommandUsageGenerator {
    /*
     * WARNING - void declaration
     */
    @Override
    public void usage(@Nullable String programName, @Nullable String groupName, String commandName, CommandMetadata command, OutputStream output) throws IOException {
        List<OptionMetadata> aOptions;
        String NEW_PARA = "\n\n";
        OutputStreamWriter writer = new OutputStreamWriter(output);
        ((Writer)writer).append(programName).append("_");
        ((Writer)writer).append(groupName).append("_");
        ((Writer)writer).append(command.getName()).append("(1) -");
        ((Writer)writer).append(command.getDescription()).append("\n");
        ((Writer)writer).append("==========");
        ((Writer)writer).append("\n\n").append("## SYNOPSIS").append("\n\n");
        List<Object> options = Lists.newArrayList();
        if (programName != null) {
            ((Writer)writer).append("`").append(programName).append("`");
            aOptions = command.getGlobalOptions();
            if (aOptions != null && aOptions.size() > 0) {
                ((Writer)writer).append(" ").append(Joiner.on((String)" ").join(this.toSynopsisUsage(this.sortOptions(aOptions))));
                options.addAll(aOptions);
            }
        }
        if (groupName != null) {
            ((Writer)writer).append(" `").append(groupName).append("`");
            aOptions = command.getGroupOptions();
            if (aOptions != null && aOptions.size() > 0) {
                ((Writer)writer).append(" ").append(Joiner.on((String)" ").join(this.toSynopsisUsage(this.sortOptions(aOptions))));
                options.addAll(aOptions);
            }
        }
        aOptions = command.getCommandOptions();
        ((Writer)writer).append(" `").append(command.getName()).append("` ").append(Joiner.on((String)" ").join(this.toSynopsisUsage(this.sortOptions(aOptions))));
        options.addAll(aOptions);
        ArgumentsMetadata arguments = command.getArguments();
        if (arguments != null) {
            ((Writer)writer).append(" [--] ").append(this.toUsage(arguments));
        }
        if (options.size() > 0 || arguments != null) {
            ((Writer)writer).append("\n\n").append("## OPTIONS");
            options = this.sortOptions((List<OptionMetadata>)options);
            for (OptionMetadata optionMetadata : options) {
                if (optionMetadata.isHidden()) continue;
                ((Writer)writer).append("\n\n").append("* ").append(this.toDescription(optionMetadata)).append(":\n");
                ((Writer)writer).append(optionMetadata.getDescription());
            }
            if (arguments != null) {
                ((Writer)writer).append("\n\n").append("* --:\n");
                ((Writer)writer).append("This option can be used to separate command-line options from the list of arguments (useful when arguments might be mistaken for command-line options).");
                ((Writer)writer).append("\n\n").append("* ").append(this.toDescription(arguments)).append(":\n");
                ((Writer)writer).append(arguments.getDescription());
            }
        }
        if (command.getDiscussion() != null) {
            ((Writer)writer).append("\n\n").append("## DISCUSSION").append("\n\n");
            ((Writer)writer).append(command.getDiscussion());
        }
        if (command.getExamples() != null && !command.getExamples().isEmpty()) {
            ((Writer)writer).append("\n\n").append("## EXAMPLES");
            for (int i = 0; i < command.getExamples().size(); i += 3) {
                void var12_17;
                String string = command.getExamples().get(i).trim();
                String aEx = this.htmlize(command.getExamples().get(i + 1));
                if (string.startsWith("*")) {
                    String string2 = string.substring(1).trim();
                }
                ((Writer)writer).append("\n\n").append("* ").append((CharSequence)var12_17).append(":\n");
                ((Writer)writer).append(aEx);
            }
        }
        ((Writer)writer).flush();
        output.flush();
    }

    @Override
    protected String toDescription(OptionMetadata option) {
        Set<String> options = option.getOptions();
        StringBuilder stringBuilder = new StringBuilder();
        final String argumentString = option.getArity() > 0 ? Joiner.on((String)" ").join((Iterable)Lists.transform((List)ImmutableList.of((Object)option.getTitle()), (Function)new Function<String, String>(){

            public String apply(@Nullable String argument) {
                return "<" + argument + ">";
            }
        })) : null;
        Joiner.on((String)", ").appendTo(stringBuilder, Iterables.transform(options, (Function)new Function<String, String>(){

            public String apply(@Nullable String option) {
                if (argumentString != null) {
                    return "`" + option + "` " + argumentString;
                }
                return "`" + option + "`";
            }
        }));
        return stringBuilder.toString();
    }
}

