/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.airline;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.airline.Context;
import io.airlift.airline.model.ArgumentsMetadata;
import io.airlift.airline.model.CommandMetadata;
import io.airlift.airline.model.MetadataLoader;
import io.airlift.airline.model.OptionMetadata;
import io.airlift.airline.parser.ParseArgumentsMissingException;
import io.airlift.airline.parser.ParseArgumentsUnexpectedException;
import io.airlift.airline.parser.ParseCommandMissingException;
import io.airlift.airline.parser.ParseCommandUnrecognizedException;
import io.airlift.airline.parser.ParseOptionMissingException;
import io.airlift.airline.parser.ParseOptionMissingValueException;
import io.airlift.airline.parser.ParseState;
import io.airlift.airline.parser.Parser;
import io.airlift.airline.parser.ParserUtil;
import java.util.List;

public class SingleCommand<C> {
    private final CommandMetadata commandMetadata;

    public static <C> SingleCommand<C> singleCommand(Class<C> command) {
        return new SingleCommand<C>(command);
    }

    private SingleCommand(Class<C> command) {
        Preconditions.checkNotNull(command, (Object)"command is null");
        this.commandMetadata = MetadataLoader.loadCommand(command);
    }

    public CommandMetadata getCommandMetadata() {
        return this.commandMetadata;
    }

    public C parse(String ... args) {
        return this.parse((Iterable<String>)ImmutableList.copyOf((Object[])args));
    }

    public C parse(Iterable<String> args) {
        Preconditions.checkNotNull(args, (Object)"args is null");
        Parser parser = new Parser();
        ParseState state = parser.parseCommand(this.commandMetadata, args);
        this.validate(state);
        CommandMetadata command = state.getCommand();
        return (C)ParserUtil.createInstance(command.getType(), command.getAllOptions(), state.getParsedOptions(), command.getArguments(), state.getParsedArguments(), command.getMetadataInjections(), ImmutableMap.of(CommandMetadata.class, (Object)this.commandMetadata));
    }

    private void validate(ParseState state) {
        CommandMetadata command = state.getCommand();
        if (command == null) {
            List<String> unparsedInput = state.getUnparsedInput();
            if (unparsedInput.isEmpty()) {
                throw new ParseCommandMissingException();
            }
            throw new ParseCommandUnrecognizedException(unparsedInput);
        }
        ArgumentsMetadata arguments = command.getArguments();
        if (state.getParsedArguments().isEmpty() && arguments != null && arguments.isRequired()) {
            throw new ParseArgumentsMissingException(arguments.getTitle());
        }
        if (!state.getUnparsedInput().isEmpty()) {
            throw new ParseArgumentsUnexpectedException(state.getUnparsedInput());
        }
        if (state.getLocation() == Context.OPTION) {
            throw new ParseOptionMissingValueException(state.getCurrentOption().getTitle());
        }
        for (OptionMetadata option : command.getAllOptions()) {
            if (!option.isRequired() || state.getParsedOptions().containsKey((Object)option)) continue;
            throw new ParseOptionMissingException(option.getOptions().iterator().next());
        }
    }
}

