/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.airline.help;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import io.airlift.airline.Arguments;
import io.airlift.airline.Command;
import io.airlift.airline.Context;
import io.airlift.airline.help.CommandSuggester;
import io.airlift.airline.help.GlobalSuggester;
import io.airlift.airline.help.GroupSuggester;
import io.airlift.airline.help.Suggester;
import io.airlift.airline.model.CommandGroupMetadata;
import io.airlift.airline.model.CommandMetadata;
import io.airlift.airline.model.GlobalMetadata;
import io.airlift.airline.model.MetadataLoader;
import io.airlift.airline.model.OptionMetadata;
import io.airlift.airline.model.SuggesterMetadata;
import io.airlift.airline.parser.ParseState;
import io.airlift.airline.parser.Parser;
import io.airlift.airline.parser.ParserUtil;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.inject.Inject;

@Command(name="suggest")
public class SuggestCommand
implements Runnable,
Callable<Void> {
    private static final Map<Context, Class<? extends Suggester>> BUILTIN_SUGGESTERS = ImmutableMap.builder().put((Object)Context.GLOBAL, GlobalSuggester.class).put((Object)Context.GROUP, GroupSuggester.class).put((Object)Context.COMMAND, CommandSuggester.class).build();
    @Inject
    public GlobalMetadata metadata;
    @Arguments
    public List<String> arguments = Lists.newArrayList();

    @VisibleForTesting
    public Iterable<String> generateSuggestions() {
        SuggesterMetadata suggesterMetadata;
        Parser parser = new Parser();
        ParseState state = parser.parse(this.metadata, this.arguments);
        Class<? extends Suggester> suggesterClass = BUILTIN_SUGGESTERS.get((Object)state.getLocation());
        if (suggesterClass != null && (suggesterMetadata = MetadataLoader.loadSuggester(suggesterClass)) != null) {
            ImmutableMap.Builder bindings = ImmutableMap.builder().put(GlobalMetadata.class, (Object)this.metadata);
            if (state.getGroup() != null) {
                bindings.put(CommandGroupMetadata.class, (Object)state.getGroup());
            }
            if (state.getCommand() != null) {
                bindings.put(CommandMetadata.class, (Object)state.getCommand());
            }
            Suggester suggester = (Suggester)ParserUtil.createInstance(suggesterMetadata.getSuggesterClass(), (Iterable<OptionMetadata>)ImmutableList.of(), null, null, null, suggesterMetadata.getMetadataInjections(), bindings.build());
            return suggester.suggest();
        }
        return ImmutableList.of();
    }

    @Override
    public void run() {
        System.out.println(Joiner.on((String)"\n").join(this.generateSuggestions()));
    }

    @Override
    public Void call() {
        this.run();
        return null;
    }
}

