/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.airline.help.cli;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.airlift.airline.help.AbstractPrintedCommandUsageGenerator;
import io.airlift.airline.help.UsageHelper;
import io.airlift.airline.help.UsagePrinter;
import io.airlift.airline.model.ArgumentsMetadata;
import io.airlift.airline.model.CommandMetadata;
import io.airlift.airline.model.OptionMetadata;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class CliCommandUsageGenerator
extends AbstractPrintedCommandUsageGenerator {
    public CliCommandUsageGenerator() {
        this(79, UsageHelper.DEFAULT_OPTION_COMPARATOR);
    }

    public CliCommandUsageGenerator(int columnSize) {
        this(columnSize, UsageHelper.DEFAULT_OPTION_COMPARATOR);
    }

    public CliCommandUsageGenerator(int columnSize, Comparator<? super OptionMetadata> optionComparator) {
        super(columnSize, optionComparator);
    }

    @Override
    protected void usage(String programName, String groupName, String commandName, CommandMetadata command, UsagePrinter out) throws IOException {
        this.outputDescription(out, programName, groupName, commandName, command);
        List<OptionMetadata> options = this.outputSynopsis(out, programName, groupName, commandName, command);
        ArgumentsMetadata arguments = command.getArguments();
        if (options.size() > 0 || arguments != null) {
            this.outputOptions(out, options, arguments);
        }
        if (command.getDiscussion() != null) {
            this.outputDiscussion(out, command);
        }
        if (command.getExamples() != null && !command.getExamples().isEmpty()) {
            this.outputExamples(out, command);
        }
        if (command.getExitCodes() != null && !command.getExitCodes().isEmpty()) {
            this.outputExitCodes(out, programName, groupName, commandName, command);
        }
    }

    protected void outputExitCodes(UsagePrinter out, String programName, String groupName, String commandName, CommandMetadata command) throws IOException {
        out.append("EXIT STATUS").newline();
        out.flush();
        UsagePrinter exitPrinter = out.newIndentedPrinter(8);
        exitPrinter.append("The ");
        if (programName != null) {
            exitPrinter.append(programName).append(" ");
        }
        if (groupName != null) {
            exitPrinter.append(groupName).append(" ");
        }
        exitPrinter.append(commandName).append(" command exits with one of the following values:").newline().newline();
        for (Map.Entry<Integer, String> exit : this.sortExitCodes(Lists.newArrayList(command.getExitCodes().entrySet()))) {
            exitPrinter.append(exit.getKey().toString());
            exitPrinter.newline();
            exitPrinter.flush();
            if (!StringUtils.isEmpty((CharSequence)exit.getValue())) {
                UsagePrinter exitDescripPrinter = exitPrinter.newIndentedPrinter(4);
                exitDescripPrinter.append(exit.getValue());
                exitDescripPrinter.flush();
            }
            exitPrinter.newline();
            exitPrinter.flush();
        }
    }

    protected void outputExamples(UsagePrinter out, CommandMetadata command) throws IOException {
        out.append("EXAMPLES").newline();
        UsagePrinter examplePrinter = out.newIndentedPrinter(8);
        examplePrinter.appendTable(Iterables.partition(command.getExamples(), (int)1));
        examplePrinter.flush();
    }

    protected void outputDiscussion(UsagePrinter out, CommandMetadata command) throws IOException {
        out.append("DISCUSSION").newline();
        UsagePrinter discussionPrinter = out.newIndentedPrinter(8);
        discussionPrinter.append(command.getDiscussion()).newline().newline();
        discussionPrinter.flush();
    }

    protected void outputOptions(UsagePrinter out, List<OptionMetadata> options, ArgumentsMetadata arguments) throws IOException {
        options = this.sortOptions(options);
        out.append("OPTIONS").newline();
        for (OptionMetadata option : options) {
            if (option.isHidden()) continue;
            UsagePrinter optionPrinter = out.newIndentedPrinter(8);
            optionPrinter.append(this.toDescription(option)).newline();
            optionPrinter.flush();
            UsagePrinter descriptionPrinter = optionPrinter.newIndentedPrinter(4);
            descriptionPrinter.append(option.getDescription()).newline();
            if (option.getAllowedValues() != null && option.getAllowedValues().size() > 0 && option.getArity() >= 1) {
                this.outputAllowedValues(descriptionPrinter, option);
            }
            descriptionPrinter.newline();
            descriptionPrinter.flush();
        }
        if (arguments != null) {
            UsagePrinter optionPrinter = out.newIndentedPrinter(8);
            optionPrinter.append("--").newline();
            optionPrinter.flush();
            UsagePrinter descriptionPrinter = optionPrinter.newIndentedPrinter(4);
            descriptionPrinter.append("This option can be used to separate command-line options from the list of argument, (useful when arguments might be mistaken for command-line options)").newline();
            descriptionPrinter.newline();
            optionPrinter.append(this.toDescription(arguments)).newline();
            descriptionPrinter.append(arguments.getDescription()).newline();
            descriptionPrinter.newline();
            descriptionPrinter.flush();
        }
    }

    protected void outputAllowedValues(UsagePrinter descriptionPrinter, OptionMetadata option) throws IOException {
        descriptionPrinter.newline();
        descriptionPrinter.append("This options value");
        if (option.getArity() == 1) {
            descriptionPrinter.append(" is ");
        } else {
            descriptionPrinter.append("s are ");
        }
        descriptionPrinter.append("restricted to the following value(s):").newline();
        UsagePrinter allowedValuesPrinter = descriptionPrinter.newIndentedPrinter(4);
        for (String value : option.getAllowedValues()) {
            allowedValuesPrinter.append(value).newline();
        }
        allowedValuesPrinter.flush();
    }

    protected List<OptionMetadata> outputSynopsis(UsagePrinter out, String programName, String groupName, String commandName, CommandMetadata command) throws IOException {
        out.append("SYNOPSIS").newline();
        UsagePrinter synopsis = out.newIndentedPrinter(8).newPrinterWithHangingIndent(8);
        ArrayList options = Lists.newArrayList();
        if (programName != null) {
            synopsis.append(programName).appendWords(this.toSynopsisUsage(this.sortOptions(command.getGlobalOptions())));
            options.addAll(command.getGlobalOptions());
        }
        if (groupName != null) {
            synopsis.append(groupName).appendWords(this.toSynopsisUsage(this.sortOptions(command.getGroupOptions())));
            options.addAll(command.getGroupOptions());
        }
        synopsis.append(commandName).appendWords(this.toSynopsisUsage(this.sortOptions(command.getCommandOptions())));
        options.addAll(command.getCommandOptions());
        if (command.getArguments() != null) {
            synopsis.append("[--]").append(this.toUsage(command.getArguments()));
        }
        synopsis.newline();
        synopsis.newline();
        return options;
    }

    protected void outputDescription(UsagePrinter out, String programName, String groupName, String commandName, CommandMetadata command) throws IOException {
        out.append("NAME").newline();
        out.newIndentedPrinter(8).append(programName).append(groupName).append(commandName).append("-").append(command.getDescription()).newline().newline();
    }
}

