/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.airline.help.cli;

import io.airlift.airline.help.AbstractPrintedGlobalUsageGenerator;
import io.airlift.airline.help.UsageHelper;
import io.airlift.airline.help.UsagePrinter;
import io.airlift.airline.model.CommandGroupMetadata;
import io.airlift.airline.model.CommandMetadata;
import io.airlift.airline.model.GlobalMetadata;
import io.airlift.airline.model.OptionMetadata;
import java.io.IOException;
import java.util.Comparator;
import java.util.List;

public class CliGlobalUsageGenerator
extends AbstractPrintedGlobalUsageGenerator {
    public CliGlobalUsageGenerator() {
        this(79);
    }

    public CliGlobalUsageGenerator(int columnSize) {
        this(columnSize, UsageHelper.DEFAULT_OPTION_COMPARATOR, UsageHelper.DEFAULT_COMMAND_COMPARATOR, UsageHelper.DEFAULT_COMMAND_GROUP_COMPARATOR);
    }

    public CliGlobalUsageGenerator(int columnSize, Comparator<? super OptionMetadata> optionComparator, Comparator<? super CommandMetadata> commandComparator, Comparator<? super CommandGroupMetadata> commandGroupComparator) {
        super(columnSize, optionComparator, commandComparator, commandGroupComparator);
    }

    @Override
    protected void usage(GlobalMetadata global, UsagePrinter out) throws IOException {
        this.outputDescription(out, global);
        this.outputSynopsis(out, global);
        List<OptionMetadata> options = this.sortOptions(global.getOptions());
        if (options.size() > 0) {
            this.outputOptions(out, options);
        }
        this.outputCommandList(out, global);
    }

    protected void outputCommandList(UsagePrinter out, GlobalMetadata global) throws IOException {
        out.append("COMMANDS").newline();
        UsagePrinter commandPrinter = out.newIndentedPrinter(8);
        for (CommandMetadata command : this.sortCommands(global.getDefaultGroupCommands())) {
            this.outputCommandDescription(commandPrinter, null, command);
        }
        for (CommandGroupMetadata group : this.sortCommandGroups(global.getCommandGroups())) {
            for (CommandMetadata command : this.sortCommands(group.getCommands())) {
                this.outputCommandDescription(commandPrinter, group, command);
            }
        }
    }

    protected void outputOptions(UsagePrinter out, List<OptionMetadata> options) throws IOException {
        out.append("OPTIONS").newline();
        for (OptionMetadata option : options) {
            if (option.isHidden()) continue;
            UsagePrinter optionPrinter = out.newIndentedPrinter(8);
            optionPrinter.append(this.toDescription(option)).newline();
            UsagePrinter descriptionPrinter = optionPrinter.newIndentedPrinter(4);
            descriptionPrinter.append(option.getDescription()).newline();
            if (option.getAllowedValues() != null && option.getAllowedValues().size() > 0 && option.getArity() >= 1) {
                this.outputAllowedValues(descriptionPrinter, option);
            }
            descriptionPrinter.newline();
        }
    }

    protected void outputAllowedValues(UsagePrinter out, OptionMetadata option) throws IOException {
        out.newline();
        out.append("This options value");
        if (option.getArity() == 1) {
            out.append(" is ");
        } else {
            out.append("s are ");
        }
        out.append("restricted to the following value(s):").newline();
        UsagePrinter allowedValuesPrinter = out.newIndentedPrinter(4);
        for (String value : option.getAllowedValues()) {
            allowedValuesPrinter.append(value).newline();
        }
        allowedValuesPrinter.flush();
    }

    protected void outputSynopsis(UsagePrinter out, GlobalMetadata global) throws IOException {
        out.append("SYNOPSIS").newline();
        out.newIndentedPrinter(8).newPrinterWithHangingIndent(8).append(global.getName()).appendWords(this.toSynopsisUsage(global.getOptions())).append("<command> [ <args> ]").newline().newline();
    }

    protected void outputDescription(UsagePrinter out, GlobalMetadata global) throws IOException {
        out.append("NAME").newline();
        out.newIndentedPrinter(8).append(global.getName()).append("-").append(global.getDescription()).newline().newline();
    }

    protected void outputCommandDescription(UsagePrinter out, CommandGroupMetadata group, CommandMetadata command) throws IOException {
        if (!command.isHidden()) {
            if (group != null) {
                out.append(group.getName());
            }
            out.append(command.getName()).newline();
            if (command.getDescription() != null) {
                out.newIndentedPrinter(4).append(command.getDescription()).newline();
            }
            out.newline();
        }
    }
}

