/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.airline.help.ronn;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.airlift.airline.help.AbstractGlobalUsageGenerator;
import io.airlift.airline.help.CommandUsageGenerator;
import io.airlift.airline.help.ronn.RonnCommandUsageGenerator;
import io.airlift.airline.model.CommandGroupMetadata;
import io.airlift.airline.model.CommandMetadata;
import io.airlift.airline.model.GlobalMetadata;
import io.airlift.airline.model.OptionMetadata;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import java.util.Set;

public class RonnGlobalUsageGenerator
extends AbstractGlobalUsageGenerator {
    protected final CommandUsageGenerator commandUsageGenerator;
    protected final int manSection;
    protected static final String NEW_PARA = "\n\n";
    protected static final String HORIZONTAL_RULE = "---";

    public RonnGlobalUsageGenerator() {
        this(1, new RonnCommandUsageGenerator(1, false));
    }

    public RonnGlobalUsageGenerator(int manSection) {
        this(manSection, new RonnCommandUsageGenerator(manSection, false));
    }

    protected RonnGlobalUsageGenerator(int manSection, CommandUsageGenerator commandUsageGenerator) {
        this.commandUsageGenerator = commandUsageGenerator;
        this.manSection = manSection;
    }

    @Override
    public void usage(GlobalMetadata global, OutputStream output) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(output);
        this.outputTitle(global, writer);
        List<Object> options = Lists.newArrayList();
        if (global.getOptions() != null && global.getOptions().size() > 0) {
            options.addAll(global.getOptions());
            options = this.sortOptions(options);
        }
        this.outputSynopsis(writer, global);
        if (options.size() > 0) {
            this.outputGlobalOptions(writer, options);
        }
        ((Writer)writer).flush();
        output.flush();
        if (global.getCommandGroups().size() > 0) {
            this.outputGroupCommandList(writer, global);
            this.outputCommandUsages(output, writer, global);
        } else {
            this.outputCommandList(writer, global);
            this.outputCommandUsages(output, writer, global);
        }
        ((Writer)writer).flush();
        output.flush();
    }

    protected void outputGroupCommandList(Writer writer, GlobalMetadata global) throws IOException {
        writer.append(NEW_PARA).append("## COMMAND GROUPS").append(NEW_PARA);
        writer.append("Commands are grouped as follows:");
        if (global.getDefaultGroupCommands().size() > 0) {
            writer.append(NEW_PARA).append("* Default (no <group> specified)");
            for (CommandMetadata command : this.sortCommands(global.getDefaultGroupCommands())) {
                if (command.isHidden()) continue;
                writer.append(NEW_PARA).append("  * `").append(this.getCommandName(global, null, command)).append("`:\n");
                writer.append("  ").append(command.getDescription());
            }
        }
        for (CommandGroupMetadata group : this.sortCommandGroups(global.getCommandGroups())) {
            writer.append(NEW_PARA).append("* **").append(group.getName()).append("**").append(NEW_PARA);
            writer.append("  ").append(group.getDescription());
            for (CommandMetadata command : this.sortCommands(group.getCommands())) {
                if (command.isHidden()) continue;
                writer.append(NEW_PARA).append("  * `").append(this.getCommandName(global, group.getName(), command)).append("`:\n");
                writer.append("  ").append(command.getDescription());
            }
        }
    }

    protected void outputCommandList(Writer writer, GlobalMetadata global) throws IOException {
        writer.append(NEW_PARA).append("## COMMANDS");
        for (CommandMetadata command : this.sortCommands(global.getDefaultGroupCommands())) {
            if (command.isHidden()) continue;
            writer.append(NEW_PARA).append("* `").append(this.getCommandName(global, null, command)).append("`:\n");
            writer.append(command.getDescription());
        }
    }

    protected void outputGlobalOptions(Writer writer, List<OptionMetadata> options) throws IOException {
        writer.append(NEW_PARA).append("## GLOBAL OPTIONS");
        options = this.sortOptions(options);
        for (OptionMetadata option : options) {
            if (option.isHidden()) continue;
            writer.append(NEW_PARA).append("* ").append(this.toDescription(option)).append(":\n");
            writer.append(option.getDescription());
            if (option.getAllowedValues() == null || option.getAllowedValues().size() <= 0 || option.getArity() < 1) continue;
            this.outputAllowedValues(writer, option);
        }
    }

    protected void outputAllowedValues(Writer writer, OptionMetadata option) throws IOException {
        writer.append(NEW_PARA).append("  This options value");
        if (option.getArity() == 1) {
            writer.append(" is ");
        } else {
            writer.append("s are ");
        }
        writer.append("restricted to the following value(s): [");
        boolean first = true;
        for (String value : option.getAllowedValues()) {
            if (first) {
                first = false;
            } else {
                writer.append(", ");
            }
            writer.append(value);
        }
        writer.append("]");
    }

    protected void outputSynopsis(Writer writer, GlobalMetadata global) throws IOException {
        writer.append(NEW_PARA).append("## SYNOPSIS").append(NEW_PARA);
        writer.append("`").append(global.getName()).append("`");
        if (global.getOptions() != null && global.getOptions().size() > 0) {
            writer.append(" ").append(Joiner.on((String)" ").join(this.toSynopsisUsage(this.sortOptions(global.getOptions()))));
        }
        if (global.getCommandGroups().size() > 0) {
            writer.append(" [<group>] <command> [command-args]");
        } else {
            writer.append(" <command> [command-args]");
        }
    }

    protected void outputTitle(GlobalMetadata global, Writer writer) throws IOException {
        writer.append(global.getName()).append("(").append(Integer.toString(this.manSection)).append(") -- ");
        writer.append(global.getDescription()).append("\n");
        writer.append("==========");
    }

    protected void outputCommandUsages(OutputStream output, Writer writer, GlobalMetadata global) throws IOException {
        writer.append(NEW_PARA).append(HORIZONTAL_RULE).append(NEW_PARA);
        this.outputDefaultGroupCommandUsages(output, writer, global);
        for (CommandGroupMetadata group : this.sortCommandGroups(global.getCommandGroups())) {
            this.outputGroupCommandUsages(output, writer, global, group);
        }
    }

    protected String getCommandName(GlobalMetadata global, String groupName, CommandMetadata command) {
        return command.getName();
    }

    protected void outputGroupCommandUsages(OutputStream output, Writer writer, GlobalMetadata global, CommandGroupMetadata group) throws IOException {
        for (CommandMetadata command : this.sortCommands(group.getCommands())) {
            if (command.isHidden()) continue;
            writer.flush();
            output.flush();
            this.commandUsageGenerator.usage(global.getName(), group.getName(), command.getName(), command, output);
            writer.append(NEW_PARA).append(HORIZONTAL_RULE).append(NEW_PARA);
        }
    }

    protected void outputDefaultGroupCommandUsages(OutputStream output, Writer writer, GlobalMetadata global) throws IOException {
        for (CommandMetadata command : this.sortCommands(global.getDefaultGroupCommands())) {
            if (command.isHidden()) continue;
            writer.flush();
            output.flush();
            this.commandUsageGenerator.usage(global.getName(), null, command.getName(), command, output);
            writer.append(NEW_PARA).append(HORIZONTAL_RULE).append(NEW_PARA);
        }
    }

    @Override
    protected String toDescription(OptionMetadata option) {
        Set<String> options = option.getOptions();
        StringBuilder stringBuilder = new StringBuilder();
        final String argumentString = option.getArity() > 0 ? Joiner.on((String)" ").join((Iterable)Lists.transform((List)ImmutableList.of((Object)option.getTitle()), (Function)new Function<String, String>(){

            public String apply(String argument) {
                return "<" + argument + ">";
            }
        })) : null;
        Joiner.on((String)", ").appendTo(stringBuilder, Iterables.transform(options, (Function)new Function<String, String>(){

            public String apply(String option) {
                if (argumentString != null) {
                    return "`" + option + "` " + argumentString;
                }
                return "`" + option + "`";
            }
        }));
        return stringBuilder.toString();
    }
}

