/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.airline.help.ronn;

import io.airlift.airline.help.CommandUsageGenerator;
import io.airlift.airline.help.ronn.RonnCommandUsageGenerator;
import io.airlift.airline.help.ronn.RonnGlobalUsageGenerator;
import io.airlift.airline.model.CommandGroupMetadata;
import io.airlift.airline.model.CommandMetadata;
import io.airlift.airline.model.GlobalMetadata;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class RonnMultiPageGlobalUsageGenerator
extends RonnGlobalUsageGenerator {
    public RonnMultiPageGlobalUsageGenerator() {
        this(1, new RonnCommandUsageGenerator(1, true));
    }

    public RonnMultiPageGlobalUsageGenerator(int manSection) {
        this(manSection, new RonnCommandUsageGenerator(manSection, true));
    }

    protected RonnMultiPageGlobalUsageGenerator(int manSection, CommandUsageGenerator commandUsageGenerator) {
        super(manSection, commandUsageGenerator);
    }

    @Override
    protected String getCommandName(GlobalMetadata global, String groupName, CommandMetadata command) {
        StringBuilder name = new StringBuilder();
        name.append(global.getName()).append("-");
        if (groupName != null) {
            name.append(groupName).append("-");
        }
        name.append(command.getName());
        name.append("(").append(Integer.toString(this.manSection)).append(")");
        return name.toString();
    }

    @Override
    protected void outputCommandUsages(OutputStream output, Writer writer, GlobalMetadata global) throws IOException {
        this.outputDefaultGroupCommandUsages(output, writer, global);
        for (CommandGroupMetadata group : this.sortCommandGroups(global.getCommandGroups())) {
            this.outputGroupCommandUsages(output, writer, global, group);
        }
    }

    @Override
    protected void outputGroupCommandUsages(OutputStream output, Writer writer, GlobalMetadata global, CommandGroupMetadata group) throws IOException {
        for (CommandMetadata command : this.sortCommands(group.getCommands())) {
            if (command.isHidden()) continue;
            output = this.createCommandFile(global, group.getName(), command);
            writer = new OutputStreamWriter(output);
            this.commandUsageGenerator.usage(global.getName(), group.getName(), command.getName(), command, output);
            this.outputReferenceToSuite(global, writer);
            writer.flush();
            output.flush();
            writer.close();
            output.close();
        }
    }

    protected void outputReferenceToSuite(GlobalMetadata global, Writer writer) throws IOException {
        writer.append("\n\n").append("## ").append(global.getName().toUpperCase()).append("\n\n");
        writer.append("Part of the `").append(global.getName()).append("(").append(Integer.toString(this.manSection)).append(")` suite");
    }

    protected FileOutputStream createCommandFile(GlobalMetadata global, String groupName, CommandMetadata command) throws FileNotFoundException {
        return new FileOutputStream(this.getCommandName(global, groupName, command).replace(String.format("(%d)", this.manSection), String.format(".%d.ronn", this.manSection)));
    }

    @Override
    protected void outputDefaultGroupCommandUsages(OutputStream output, Writer writer, GlobalMetadata global) throws IOException {
        for (CommandMetadata command : this.sortCommands(global.getDefaultGroupCommands())) {
            if (command.isHidden()) continue;
            output = this.createCommandFile(global, null, command);
            writer = new OutputStreamWriter(output);
            this.commandUsageGenerator.usage(global.getName(), null, command.getName(), command, output);
            this.outputReferenceToSuite(global, writer);
            writer.flush();
            output.flush();
            writer.close();
            output.close();
        }
    }
}

