/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.airline.model;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.airline.Accessor;
import io.airlift.airline.Group;
import io.airlift.airline.model.ArgumentsMetadata;
import io.airlift.airline.model.OptionMetadata;
import java.util.List;
import java.util.Map;

public class CommandMetadata {
    private final String name;
    private final String description;
    private final boolean hidden;
    private final List<OptionMetadata> globalOptions;
    private final List<OptionMetadata> groupOptions;
    private final List<OptionMetadata> commandOptions;
    private final OptionMetadata defaultOption;
    private final ArgumentsMetadata arguments;
    private final List<Accessor> metadataInjections;
    private final Class<?> type;
    private final List<String> groupNames;
    private final List<Group> groups;
    private final Map<Integer, String> exitCodes;
    private final List<String> examples;
    private final String discussion;

    public CommandMetadata(String name, String description, String discussion, List<String> examples, boolean hidden, Iterable<OptionMetadata> globalOptions, Iterable<OptionMetadata> groupOptions, Iterable<OptionMetadata> commandOptions, OptionMetadata defaultOption, ArgumentsMetadata arguments, Iterable<Accessor> metadataInjections, Class<?> type, List<String> groupNames, List<Group> groups, Map<Integer, String> exitCodes) {
        this.name = name;
        this.description = description;
        this.hidden = hidden;
        this.globalOptions = ImmutableList.copyOf(globalOptions);
        this.groupOptions = ImmutableList.copyOf(groupOptions);
        this.commandOptions = ImmutableList.copyOf(commandOptions);
        this.defaultOption = defaultOption;
        this.arguments = arguments;
        if (this.defaultOption != null && this.arguments != null) {
            throw new IllegalArgumentException("Command cannot declare both @Arguments and @DefaultOption");
        }
        this.metadataInjections = ImmutableList.copyOf(metadataInjections);
        this.type = type;
        this.discussion = discussion;
        this.examples = examples;
        this.groupNames = groupNames;
        this.groups = groups;
        this.exitCodes = ImmutableMap.copyOf(exitCodes);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public List<OptionMetadata> getAllOptions() {
        return ImmutableList.builder().addAll(this.globalOptions).addAll(this.groupOptions).addAll(this.commandOptions).build();
    }

    public List<String> getExamples() {
        return this.examples;
    }

    public String getDiscussion() {
        return this.discussion;
    }

    public List<OptionMetadata> getGlobalOptions() {
        return this.globalOptions;
    }

    public List<OptionMetadata> getGroupOptions() {
        return this.groupOptions;
    }

    public List<OptionMetadata> getCommandOptions() {
        return this.commandOptions;
    }

    public OptionMetadata getDefaultOption() {
        return this.defaultOption;
    }

    public ArgumentsMetadata getArguments() {
        return this.arguments;
    }

    public List<Accessor> getMetadataInjections() {
        return this.metadataInjections;
    }

    public Class<?> getType() {
        return this.type;
    }

    public List<String> getGroupNames() {
        return this.groupNames;
    }

    public List<Group> getGroups() {
        return this.groups;
    }

    public Map<Integer, String> getExitCodes() {
        return this.exitCodes;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CommandMetadata");
        sb.append("{name='").append(this.name).append('\'');
        sb.append(", description='").append(this.description).append('\'');
        sb.append(", discussion='").append(this.discussion).append('\'');
        sb.append(", examples='").append(this.examples).append('\'');
        sb.append(", globalOptions=").append(this.globalOptions);
        sb.append(", groupOptions=").append(this.groupOptions);
        sb.append(", commandOptions=").append(this.commandOptions);
        sb.append(", arguments=").append(this.arguments);
        sb.append(", metadataInjections=").append(this.metadataInjections);
        sb.append(", type=").append(this.type);
        sb.append('}');
        return sb.toString();
    }

    public static Function<CommandMetadata, String> nameGetter() {
        return new Function<CommandMetadata, String>(){

            public String apply(CommandMetadata input) {
                return input.getName();
            }
        };
    }

    public static Function<CommandMetadata, Class> typeGetter() {
        return new Function<CommandMetadata, Class>(){

            public Class<?> apply(CommandMetadata input) {
                return input.getType();
            }
        };
    }
}

