/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.airline.model;

import com.google.common.collect.ImmutableList;
import io.airlift.airline.model.CommandGroupMetadata;
import io.airlift.airline.model.CommandMetadata;
import io.airlift.airline.model.OptionMetadata;
import java.util.List;

public class GlobalMetadata {
    private final String name;
    private final String description;
    private final List<OptionMetadata> options;
    private final CommandMetadata defaultCommand;
    private final List<CommandMetadata> defaultGroupCommands;
    private final List<CommandGroupMetadata> commandGroups;
    private final boolean allowAbbreviatedCommands;
    private final boolean allowAbbreviatedOptions;

    public GlobalMetadata(String name, String description, Iterable<OptionMetadata> options, CommandMetadata defaultCommand, Iterable<CommandMetadata> defaultGroupCommands, Iterable<CommandGroupMetadata> commandGroups, boolean allowAbbreviatedCommands, boolean allowAbbreviatedOptions) {
        this.name = name;
        this.description = description;
        this.options = ImmutableList.copyOf(options);
        this.defaultCommand = defaultCommand;
        this.defaultGroupCommands = ImmutableList.copyOf(defaultGroupCommands);
        this.commandGroups = ImmutableList.copyOf(commandGroups);
        this.allowAbbreviatedCommands = allowAbbreviatedCommands;
        this.allowAbbreviatedOptions = allowAbbreviatedOptions;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List<OptionMetadata> getOptions() {
        return this.options;
    }

    public CommandMetadata getDefaultCommand() {
        return this.defaultCommand;
    }

    public List<CommandMetadata> getDefaultGroupCommands() {
        return this.defaultGroupCommands;
    }

    public List<CommandGroupMetadata> getCommandGroups() {
        return this.commandGroups;
    }

    public boolean allowsAbbreviatedCommands() {
        return this.allowAbbreviatedCommands;
    }

    public boolean allowsAbbreviatedOptions() {
        return this.allowAbbreviatedOptions;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("GlobalMetadata");
        sb.append("{name='").append(this.name).append('\'');
        sb.append(", description='").append(this.description).append('\'');
        sb.append(", options=").append(this.options);
        sb.append(", defaultCommand=").append(this.defaultCommand);
        sb.append(", defaultGroupCommands=").append(this.defaultGroupCommands);
        sb.append(", commandGroups=").append(this.commandGroups);
        sb.append(", allowAbbreviatedCommands=").append(this.allowAbbreviatedCommands);
        sb.append(", allowAbbreviatedOptions=").append(this.allowAbbreviatedOptions);
        sb.append('}');
        return sb.toString();
    }
}

