/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.airline.model;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import io.airlift.airline.Accessor;
import io.airlift.airline.Arguments;
import io.airlift.airline.Command;
import io.airlift.airline.DefaultOption;
import io.airlift.airline.Group;
import io.airlift.airline.Groups;
import io.airlift.airline.Option;
import io.airlift.airline.OptionType;
import io.airlift.airline.help.Suggester;
import io.airlift.airline.model.ArgumentsMetadata;
import io.airlift.airline.model.CommandGroupMetadata;
import io.airlift.airline.model.CommandMetadata;
import io.airlift.airline.model.GlobalMetadata;
import io.airlift.airline.model.OptionMetadata;
import io.airlift.airline.model.SuggesterMetadata;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;

public class MetadataLoader {
    public static GlobalMetadata loadGlobal(String name, String description, CommandMetadata defaultCommand, Iterable<CommandMetadata> defaultGroupCommands, Iterable<CommandGroupMetadata> groups, boolean allowAbbreviatedCommands, boolean allowAbbreviatedOptions) {
        ImmutableList.Builder globalOptionsBuilder = ImmutableList.builder();
        if (defaultCommand != null) {
            globalOptionsBuilder.addAll(defaultCommand.getGlobalOptions());
        }
        for (CommandMetadata command : defaultGroupCommands) {
            globalOptionsBuilder.addAll(command.getGlobalOptions());
        }
        for (CommandGroupMetadata group : groups) {
            for (CommandMetadata command : group.getCommands()) {
                globalOptionsBuilder.addAll(command.getGlobalOptions());
            }
        }
        List<OptionMetadata> globalOptions = MetadataLoader.mergeOptionSet((List<OptionMetadata>)globalOptionsBuilder.build());
        return new GlobalMetadata(name, description, globalOptions, defaultCommand, defaultGroupCommands, groups, allowAbbreviatedCommands, allowAbbreviatedOptions);
    }

    public static CommandGroupMetadata loadCommandGroup(String name, String description, CommandMetadata defaultCommand, Iterable<CommandMetadata> commands) {
        ImmutableList.Builder groupOptionsBuilder = ImmutableList.builder();
        if (defaultCommand != null) {
            groupOptionsBuilder.addAll(defaultCommand.getGroupOptions());
        }
        for (CommandMetadata command : commands) {
            groupOptionsBuilder.addAll(command.getGroupOptions());
        }
        List<OptionMetadata> groupOptions = MetadataLoader.mergeOptionSet((List<OptionMetadata>)groupOptionsBuilder.build());
        return new CommandGroupMetadata(name, description, groupOptions, defaultCommand, commands);
    }

    public static <T> ImmutableList<CommandMetadata> loadCommands(Iterable<Class<? extends T>> defaultCommands) {
        return ImmutableList.copyOf((Iterable)Iterables.transform(defaultCommands, (Function)new Function<Class<?>, CommandMetadata>(){

            public CommandMetadata apply(Class<?> commandType) {
                return MetadataLoader.loadCommand(commandType);
            }
        }));
    }

    public static CommandMetadata loadCommand(Class<?> commandType) {
        if (commandType == null) {
            return null;
        }
        Command command = null;
        ArrayList groups = Lists.newArrayList();
        Class<?> cls = commandType;
        while (command == null && !Object.class.equals(cls)) {
            command = cls.getAnnotation(Command.class);
            if (cls.isAnnotationPresent(Groups.class)) {
                groups.addAll(Arrays.asList(cls.getAnnotation(Groups.class).value()));
            }
            if (cls.isAnnotationPresent(Group.class)) {
                groups.add(cls.getAnnotation(Group.class));
            }
            cls = cls.getSuperclass();
        }
        Preconditions.checkArgument((command != null ? 1 : 0) != 0, (String)"Command %s is not annotated with @Command", (Object[])new Object[]{commandType.getName()});
        String name = command.name();
        String description = command.description().isEmpty() ? null : command.description();
        List<String> groupNames = Arrays.asList(command.groupNames());
        boolean hidden = command.hidden();
        HashMap<Integer, String> exitCodes = new HashMap<Integer, String>();
        if (command.exitCodes() != null) {
            String[] exitDescriptions = command.exitDescriptions() != null ? command.exitDescriptions() : new String[command.exitCodes().length];
            for (int i = 0; i < command.exitCodes().length; ++i) {
                String exitDescrip = exitDescriptions.length > i ? exitDescriptions[i] : null;
                exitCodes.put(command.exitCodes()[i], exitDescrip);
            }
        }
        InjectionMetadata injectionMetadata = MetadataLoader.loadInjectionMetadata(commandType);
        CommandMetadata commandMetadata = new CommandMetadata(name, description, command.discussion().isEmpty() ? null : command.discussion(), command.examples().length == 0 ? null : Lists.newArrayList((Object[])command.examples()), hidden, injectionMetadata.globalOptions, injectionMetadata.groupOptions, injectionMetadata.commandOptions, injectionMetadata.defaultOption, (ArgumentsMetadata)Iterables.getFirst((Iterable)injectionMetadata.arguments, null), injectionMetadata.metadataInjections, commandType, groupNames, groups, exitCodes);
        return commandMetadata;
    }

    public static SuggesterMetadata loadSuggester(Class<? extends Suggester> suggesterClass) {
        InjectionMetadata injectionMetadata = MetadataLoader.loadInjectionMetadata(suggesterClass);
        return new SuggesterMetadata(suggesterClass, injectionMetadata.metadataInjections);
    }

    public static InjectionMetadata loadInjectionMetadata(Class<?> type) {
        InjectionMetadata injectionMetadata = new InjectionMetadata();
        MetadataLoader.loadInjectionMetadata(type, injectionMetadata, (List<Field>)ImmutableList.of());
        injectionMetadata.compact();
        return injectionMetadata;
    }

    public static void loadInjectionMetadata(Class<?> type, InjectionMetadata injectionMetadata, List<Field> fields) {
        if (type.isInterface()) {
            return;
        }
        Class<?> cls = type;
        while (!Object.class.equals(cls)) {
            for (Field field : cls.getDeclaredFields()) {
                field.setAccessible(true);
                ImmutableList<Field> path = MetadataLoader.concat(fields, field);
                Inject injectAnnotation = field.getAnnotation(Inject.class);
                if (injectAnnotation != null) {
                    if (field.getType().equals(GlobalMetadata.class) || field.getType().equals(CommandGroupMetadata.class) || field.getType().equals(CommandMetadata.class)) {
                        injectionMetadata.metadataInjections.add(new Accessor((Iterable<Field>)path));
                    } else {
                        MetadataLoader.loadInjectionMetadata(field.getType(), injectionMetadata, path);
                    }
                }
                try {
                    Object aGuiceInject = field.getAnnotation(Class.forName("com.google.inject.Inject"));
                    if (aGuiceInject != null) {
                        if (field.getType().equals(GlobalMetadata.class) || field.getType().equals(CommandGroupMetadata.class) || field.getType().equals(CommandMetadata.class)) {
                            injectionMetadata.metadataInjections.add(new Accessor((Iterable<Field>)path));
                        } else {
                            MetadataLoader.loadInjectionMetadata(field.getType(), injectionMetadata, path);
                        }
                    }
                }
                catch (ClassNotFoundException e) {
                }
                catch (ClassCastException e) {
                    // empty catch block
                }
                Option optionAnnotation = field.getAnnotation(Option.class);
                DefaultOption defaultOptionAnnotation = field.getAnnotation(DefaultOption.class);
                if (optionAnnotation != null) {
                    Class<?> fieldType;
                    OptionType optionType = optionAnnotation.type();
                    String name = !optionAnnotation.title().isEmpty() ? optionAnnotation.title() : field.getName();
                    ImmutableList options = ImmutableList.copyOf((Object[])optionAnnotation.name());
                    String description = optionAnnotation.description();
                    int arity = optionAnnotation.arity();
                    Preconditions.checkArgument((arity >= 0 || arity == Integer.MIN_VALUE ? 1 : 0) != 0, (String)"Invalid arity for option %s", (Object[])new Object[]{name});
                    arity = optionAnnotation.arity() >= 0 ? optionAnnotation.arity() : (Boolean.class.isAssignableFrom(fieldType = field.getType()) || Boolean.TYPE.isAssignableFrom(fieldType) ? 0 : 1);
                    boolean required = optionAnnotation.required();
                    boolean hidden = optionAnnotation.hidden();
                    boolean override = optionAnnotation.override();
                    boolean sealed = optionAnnotation.sealed();
                    ImmutableList allowedValues = ImmutableList.copyOf((Object[])optionAnnotation.allowedValues());
                    if (allowedValues.isEmpty()) {
                        allowedValues = null;
                    }
                    OptionMetadata optionMetadata = new OptionMetadata(optionType, (Iterable<String>)options, name, description, arity, required, hidden, override, sealed, (Iterable<String>)allowedValues, optionAnnotation.completionBehaviour(), optionAnnotation.completionCommand(), (Iterable<Field>)path);
                    switch (optionType) {
                        case GLOBAL: {
                            if (defaultOptionAnnotation != null) {
                                throw new IllegalArgumentException(String.format("Field %s which defines a global option cannot be annotated with @DefaultOption as this may only be applied to command options", field));
                            }
                            injectionMetadata.globalOptions.add(optionMetadata);
                            break;
                        }
                        case GROUP: {
                            if (defaultOptionAnnotation != null) {
                                throw new IllegalArgumentException(String.format("Field %s which defines a global option cannot be annotated with @DefaultOption as this may only be applied to command options", field));
                            }
                            injectionMetadata.groupOptions.add(optionMetadata);
                            break;
                        }
                        case COMMAND: {
                            if (defaultOptionAnnotation != null) {
                                if (injectionMetadata.arguments.size() > 0) {
                                    throw new IllegalArgumentException(String.format("Field %s cannot be annotated with @DefaultOption because there are fields with @Arguments annotations present", field));
                                }
                                if (injectionMetadata.defaultOption != null) {
                                    throw new IllegalArgumentException(String.format("Command type %s has more than one field with @DefaultOption declared upon it", type));
                                }
                                if (optionMetadata.getArity() != 1) {
                                    throw new IllegalArgumentException(String.format("Field %s annotated with @DefaultOption must also have an @Option annotation with an arity of 1", field));
                                }
                                injectionMetadata.defaultOption = optionMetadata;
                            }
                            injectionMetadata.commandOptions.add(optionMetadata);
                        }
                    }
                }
                if (optionAnnotation == null && defaultOptionAnnotation != null) {
                    throw new IllegalArgumentException(String.format("Field %s annotated with @DefaultOption must also have an @Option annotation", field));
                }
                Arguments argumentsAnnotation = field.getAnnotation(Arguments.class);
                if (!field.isAnnotationPresent(Arguments.class)) continue;
                if (injectionMetadata.defaultOption != null) {
                    throw new IllegalArgumentException(String.format("Field %s cannot be annotated with @Arguments because there is a field with @DefaultOption present", field));
                }
                ImmutableList.Builder titlesBuilder = ImmutableList.builder();
                if (argumentsAnnotation.title().length != 1 || !argumentsAnnotation.title()[0].equals("")) {
                    titlesBuilder.add((Object[])argumentsAnnotation.title());
                } else {
                    titlesBuilder.add((Object)field.getName());
                }
                String description = argumentsAnnotation.description();
                String usage = argumentsAnnotation.usage();
                boolean required = argumentsAnnotation.required();
                int arity = argumentsAnnotation.arity() <= 0 ? Integer.MIN_VALUE : argumentsAnnotation.arity();
                injectionMetadata.arguments.add(new ArgumentsMetadata((Iterable<String>)titlesBuilder.build(), description, usage, required, arity, argumentsAnnotation.completionBehaviour(), argumentsAnnotation.completionCommand(), (Iterable<Field>)path));
            }
            cls = cls.getSuperclass();
        }
    }

    private static List<OptionMetadata> mergeOptionSet(List<OptionMetadata> options) {
        Multimap metadataIndex = Multimaps.newMultimap((Map)Maps.newLinkedHashMap(), (Supplier)new Supplier<List<OptionMetadata>>(){

            public List<OptionMetadata> get() {
                return Lists.newArrayList();
            }
        });
        for (OptionMetadata option : options) {
            metadataIndex.put((Object)option, (Object)option);
        }
        options = ImmutableList.copyOf((Iterable)Iterables.transform(metadataIndex.asMap().values(), (Function)new Function<Collection<OptionMetadata>, OptionMetadata>(){

            public OptionMetadata apply(Collection<OptionMetadata> options) {
                return new OptionMetadata(options);
            }
        }));
        LinkedHashMap optionIndex = Maps.newLinkedHashMap();
        for (OptionMetadata option : options) {
            for (String optionName : option.getOptions()) {
                if (optionIndex.containsKey(optionName)) {
                    throw new IllegalArgumentException(String.format("Fields %s and %s have conflicting definitions of option %s", ((OptionMetadata)optionIndex.get(optionName)).getAccessors().iterator().next(), option.getAccessors().iterator().next(), optionName));
                }
                optionIndex.put(optionName, option);
            }
        }
        return options;
    }

    private static List<OptionMetadata> overrideOptionSet(List<OptionMetadata> options) {
        options = ImmutableList.copyOf(options);
        HashMap optionIndex = Maps.newHashMap();
        for (OptionMetadata option : options) {
            Set<String> names = option.getOptions();
            if (optionIndex.containsKey(names)) {
                MetadataLoader.tryOverrideOptions(optionIndex, names, option);
                continue;
            }
            for (Set existingNames : optionIndex.keySet()) {
                Sets.SetView intersection = Sets.intersection(names, (Set)existingNames);
                if (intersection.size() <= 0) continue;
                throw new IllegalArgumentException(String.format("Fields %s and %s have overlapping definitions of option %s, options can only be overridden if they have precisely the same set of option names", option.getAccessors().iterator().next(), ((OptionMetadata)optionIndex.get(existingNames)).getAccessors().iterator().next(), intersection));
            }
            optionIndex.put(names, option);
        }
        return ImmutableList.copyOf(optionIndex.values());
    }

    private static void tryOverrideOptions(Map<Set<String>, OptionMetadata> optionIndex, Set<String> names, OptionMetadata parent) {
        boolean isDuplicate;
        OptionMetadata child = optionIndex.get(names);
        Accessor parentField = parent.getAccessors().iterator().next();
        Accessor childField = child.getAccessors().iterator().next();
        boolean bl = isDuplicate = parent == child || parent.equals(child);
        if (parent.isSealed() && !isDuplicate) {
            throw new IllegalArgumentException(String.format("Fields %s and %s have conflicting definitions of option %s - parent field %s declares itself as sealed and cannot be overridden", parentField, childField, names, parentField));
        }
        if (!child.isOverride() && !isDuplicate) {
            throw new IllegalArgumentException(String.format("Fields %s and %s have conflicting definitions of option %s - if you wanted to override this option you must explicitly specify override = true in your child field annotation", parentField, childField, names));
        }
        OptionMetadata merged = OptionMetadata.override(names, parent, child);
        optionIndex.put(names, merged);
    }

    private static <T> ImmutableList<T> concat(Iterable<T> iterable, T item) {
        return ImmutableList.builder().addAll(iterable).add(item).build();
    }

    public static void loadCommandsIntoGroupsByAnnotation(List<CommandMetadata> allCommands, List<CommandGroupMetadata> commandGroups, List<CommandMetadata> defaultCommandGroup) {
        ArrayList<CommandMetadata> newCommands = new ArrayList<CommandMetadata>();
        MetadataLoader.createGroupsFromAnnotations(allCommands, newCommands, commandGroups, defaultCommandGroup);
        for (CommandMetadata command : allCommands) {
            boolean added = false;
            for (String groupName : command.getGroupNames()) {
                CommandGroupMetadata group = (CommandGroupMetadata)Iterables.find(commandGroups, (Predicate)Predicates.compose((Predicate)Predicates.equalTo((Object)groupName), CommandGroupMetadata.nameGetter()), null);
                if (group != null) {
                    group.addCommand(command);
                    added = true;
                    continue;
                }
                ImmutableList.Builder groupOptionsBuilder = ImmutableList.builder();
                groupOptionsBuilder.addAll(command.getGroupOptions());
                CommandGroupMetadata newGroup = MetadataLoader.loadCommandGroup(groupName, "", null, Collections.singletonList(command));
                commandGroups.add(newGroup);
                added = true;
            }
            if (!added || !defaultCommandGroup.contains(command)) continue;
            defaultCommandGroup.remove(command);
        }
        allCommands.addAll(newCommands);
    }

    private static void createGroupsFromAnnotations(List<CommandMetadata> allCommands, List<CommandMetadata> newCommands, List<CommandGroupMetadata> commandGroups, List<CommandMetadata> defaultCommandGroup) {
        for (CommandMetadata command : allCommands) {
            boolean added = false;
            for (Group groupAnno : command.getGroups()) {
                Class<?> defaultCommandClass = null;
                CommandMetadata defaultCommand = null;
                if (!groupAnno.defaultCommand().equals(Group.DEFAULT.class) && null == (defaultCommand = (CommandMetadata)Iterables.find(allCommands, (Predicate)Predicates.compose((Predicate)Predicates.equalTo(defaultCommandClass = groupAnno.defaultCommand()), CommandMetadata.typeGetter()), null))) {
                    defaultCommand = MetadataLoader.loadCommand(defaultCommandClass);
                    newCommands.add(defaultCommand);
                }
                ArrayList<CommandMetadata> groupCommands = new ArrayList<CommandMetadata>(groupAnno.commands().length);
                CommandMetadata groupCommand = null;
                for (Class<?> commandClass : groupAnno.commands()) {
                    groupCommand = (CommandMetadata)Iterables.find(allCommands, (Predicate)Predicates.compose((Predicate)Predicates.equalTo(commandClass), CommandMetadata.typeGetter()), null);
                    if (null != groupCommand) continue;
                    groupCommand = MetadataLoader.loadCommand(commandClass);
                    newCommands.add(groupCommand);
                    groupCommands.add(groupCommand);
                }
                CommandGroupMetadata groupMetadata = (CommandGroupMetadata)Iterables.find(commandGroups, (Predicate)Predicates.compose((Predicate)Predicates.equalTo((Object)groupAnno.name()), CommandGroupMetadata.nameGetter()), null);
                if (null == groupMetadata) {
                    groupMetadata = MetadataLoader.loadCommandGroup(groupAnno.name(), groupAnno.description(), defaultCommand, groupCommands);
                    commandGroups.add(groupMetadata);
                }
                groupMetadata.addCommand(command);
                added = true;
            }
            if (!added || !defaultCommandGroup.contains(command)) continue;
            defaultCommandGroup.remove(command);
        }
    }

    private static class InjectionMetadata {
        private List<OptionMetadata> globalOptions = Lists.newArrayList();
        private List<OptionMetadata> groupOptions = Lists.newArrayList();
        private List<OptionMetadata> commandOptions = Lists.newArrayList();
        private OptionMetadata defaultOption = null;
        private List<ArgumentsMetadata> arguments = Lists.newArrayList();
        private List<Accessor> metadataInjections = Lists.newArrayList();

        private InjectionMetadata() {
        }

        private void compact() {
            this.globalOptions = MetadataLoader.overrideOptionSet(this.globalOptions);
            this.groupOptions = MetadataLoader.overrideOptionSet(this.groupOptions);
            this.commandOptions = MetadataLoader.overrideOptionSet(this.commandOptions);
            if (this.defaultOption != null) {
                for (OptionMetadata option : this.commandOptions) {
                    if (Sets.intersection(option.getOptions(), this.defaultOption.getOptions()).size() <= 0) continue;
                    this.defaultOption = option;
                    break;
                }
            }
            if (this.arguments.size() > 1) {
                this.arguments = ImmutableList.of((Object)new ArgumentsMetadata(this.arguments));
            }
        }
    }
}

