/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.airline.parser;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import io.airlift.airline.Context;
import io.airlift.airline.model.CommandGroupMetadata;
import io.airlift.airline.model.CommandMetadata;
import io.airlift.airline.model.GlobalMetadata;
import io.airlift.airline.model.OptionMetadata;
import java.util.List;

public class ParseState {
    private final List<Context> locationStack;
    private final GlobalMetadata global;
    private final CommandGroupMetadata group;
    private final CommandMetadata command;
    private final ListMultimap<OptionMetadata, Object> parsedOptions;
    private final List<Object> parsedArguments;
    private final OptionMetadata currentOption;
    private final List<String> unparsedInput;

    ParseState(GlobalMetadata global, CommandGroupMetadata group, CommandMetadata command, ListMultimap<OptionMetadata, Object> parsedOptions, List<Context> locationStack, List<Object> parsedArguments, OptionMetadata currentOption, List<String> unparsedInput) {
        this.global = global;
        this.group = group;
        this.command = command;
        this.parsedOptions = parsedOptions;
        this.locationStack = locationStack;
        this.parsedArguments = parsedArguments;
        this.currentOption = currentOption;
        this.unparsedInput = unparsedInput;
    }

    public static ParseState newInstance() {
        return new ParseState(null, null, null, (ListMultimap<OptionMetadata, Object>)ArrayListMultimap.create(), (List<Context>)ImmutableList.of(), (List<Object>)ImmutableList.of(), null, (List<String>)ImmutableList.of());
    }

    public ParseState pushContext(Context location) {
        ImmutableList locationStack = ImmutableList.builder().addAll(this.locationStack).add((Object)location).build();
        return new ParseState(this.global, this.group, this.command, this.parsedOptions, (List<Context>)locationStack, this.parsedArguments, this.currentOption, this.unparsedInput);
    }

    public ParseState popContext() {
        ImmutableList locationStack = ImmutableList.copyOf(this.locationStack.subList(0, this.locationStack.size() - 1));
        return new ParseState(this.global, this.group, this.command, this.parsedOptions, (List<Context>)locationStack, this.parsedArguments, this.currentOption, this.unparsedInput);
    }

    public ParseState withOptionValue(OptionMetadata option, Object value) {
        ImmutableListMultimap newOptions = ImmutableListMultimap.builder().putAll(this.parsedOptions).put((Object)option, value).build();
        return new ParseState(this.global, this.group, this.command, (ListMultimap<OptionMetadata, Object>)newOptions, this.locationStack, this.parsedArguments, this.currentOption, this.unparsedInput);
    }

    public ParseState withGlobal(GlobalMetadata global) {
        return new ParseState(global, this.group, this.command, this.parsedOptions, this.locationStack, this.parsedArguments, this.currentOption, this.unparsedInput);
    }

    public ParseState withGroup(CommandGroupMetadata group) {
        return new ParseState(this.global, group, this.command, this.parsedOptions, this.locationStack, this.parsedArguments, this.currentOption, this.unparsedInput);
    }

    public ParseState withCommand(CommandMetadata command) {
        return new ParseState(this.global, this.group, command, this.parsedOptions, this.locationStack, this.parsedArguments, this.currentOption, this.unparsedInput);
    }

    public ParseState withOption(OptionMetadata option) {
        return new ParseState(this.global, this.group, this.command, this.parsedOptions, this.locationStack, this.parsedArguments, option, this.unparsedInput);
    }

    public ParseState withArgument(Object argument) {
        ImmutableList newArguments = ImmutableList.builder().addAll(this.parsedArguments).add(argument).build();
        return new ParseState(this.global, this.group, this.command, this.parsedOptions, this.locationStack, (List<Object>)newArguments, this.currentOption, this.unparsedInput);
    }

    public ParseState withUnparsedInput(String input) {
        ImmutableList newUnparsedInput = ImmutableList.builder().addAll(this.unparsedInput).add((Object)input).build();
        return new ParseState(this.global, this.group, this.command, this.parsedOptions, this.locationStack, this.parsedArguments, this.currentOption, (List<String>)newUnparsedInput);
    }

    public String toString() {
        return "ParseState{locationStack=" + this.locationStack + ", global=" + this.global + ", group=" + this.group + ", command=" + this.command + ", parsedOptions=" + this.parsedOptions + ", parsedArguments=" + this.parsedArguments + ", currentOption=" + this.currentOption + ", unparsedInput=" + this.unparsedInput + '}';
    }

    public Context getLocation() {
        return this.locationStack.get(this.locationStack.size() - 1);
    }

    public GlobalMetadata getGlobal() {
        return this.global;
    }

    public CommandGroupMetadata getGroup() {
        return this.group;
    }

    public CommandMetadata getCommand() {
        return this.command;
    }

    public OptionMetadata getCurrentOption() {
        return this.currentOption;
    }

    public ListMultimap<OptionMetadata, Object> getParsedOptions() {
        return this.parsedOptions;
    }

    public List<Object> getParsedArguments() {
        return this.parsedArguments;
    }

    public List<String> getUnparsedInput() {
        return this.unparsedInput;
    }
}

