/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.airline.parser;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import io.airlift.airline.Context;
import io.airlift.airline.TypeConverter;
import io.airlift.airline.model.ArgumentsMetadata;
import io.airlift.airline.model.CommandGroupMetadata;
import io.airlift.airline.model.CommandMetadata;
import io.airlift.airline.model.GlobalMetadata;
import io.airlift.airline.model.OptionMetadata;
import io.airlift.airline.parser.AbbreviatedCommandFinder;
import io.airlift.airline.parser.AbbreviatedGroupFinder;
import io.airlift.airline.parser.AbbreviatedOptionFinder;
import io.airlift.airline.parser.ParseOptionIllegalValueException;
import io.airlift.airline.parser.ParseState;
import io.airlift.airline.parser.ParseTooManyArgumentsException;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;

public class Parser {
    private static final Pattern SHORT_OPTIONS_PATTERN = Pattern.compile("-[^-].*");

    public ParseState parse(GlobalMetadata metadata, String ... params) {
        return this.parse(metadata, (Iterable<String>)ImmutableList.copyOf((Object[])params));
    }

    public ParseState parse(GlobalMetadata metadata, Iterable<String> params) {
        ParseState state;
        block9: {
            PeekingIterator tokens = Iterators.peekingIterator(params.iterator());
            state = ParseState.newInstance().pushContext(Context.GLOBAL).withGlobal(metadata);
            state = this.parseOptions((PeekingIterator<String>)tokens, state, metadata.getOptions());
            if (tokens.hasNext()) {
                AbbreviatedGroupFinder findGroupPredicate = metadata != null && metadata.allowsAbbreviatedCommands() ? new AbbreviatedGroupFinder((String)tokens.peek(), (Collection<CommandGroupMetadata>)metadata.getCommandGroups()) : Predicates.compose((Predicate)Predicates.equalTo((Object)tokens.peek()), CommandGroupMetadata.nameGetter());
                CommandGroupMetadata group = (CommandGroupMetadata)Iterables.find(metadata.getCommandGroups(), (Predicate)findGroupPredicate, null);
                if (group != null) {
                    tokens.next();
                    state = state.withGroup(group).pushContext(Context.GROUP);
                    state = this.parseOptions((PeekingIterator<String>)tokens, state, state.getGroup().getOptions());
                }
            }
            List<CommandMetadata> expectedCommands = metadata.getDefaultGroupCommands();
            if (state.getGroup() != null) {
                expectedCommands = state.getGroup().getCommands();
            }
            if (!tokens.hasNext()) break block9;
            AbbreviatedCommandFinder findCommandPredicate = metadata != null && metadata.allowsAbbreviatedCommands() ? new AbbreviatedCommandFinder((String)tokens.peek(), (Collection<CommandMetadata>)expectedCommands) : Predicates.compose((Predicate)Predicates.equalTo((Object)tokens.peek()), CommandMetadata.nameGetter());
            CommandMetadata command = (CommandMetadata)Iterables.find(expectedCommands, (Predicate)findCommandPredicate, state.getGroup() != null ? state.getGroup().getDefaultCommand() : null);
            boolean usingDefault = false;
            if (command == null && state.getGroup() == null && metadata.getDefaultCommand() != null) {
                usingDefault = true;
                command = metadata.getDefaultCommand();
            }
            if (command == null) {
                while (tokens.hasNext()) {
                    state = state.withUnparsedInput((String)tokens.next());
                }
            } else {
                if (((String)tokens.peek()).equals(command.getName()) || !usingDefault && metadata.allowsAbbreviatedCommands()) {
                    tokens.next();
                }
                state = state.withCommand(command).pushContext(Context.COMMAND);
                while (tokens.hasNext()) {
                    state = this.parseOptions((PeekingIterator<String>)tokens, state, command.getCommandOptions());
                    state = this.parseArgs(state, (PeekingIterator<String>)tokens, command.getArguments(), command.getDefaultOption());
                }
            }
        }
        return state;
    }

    public ParseState parseCommand(CommandMetadata command, Iterable<String> params) {
        PeekingIterator tokens = Iterators.peekingIterator(params.iterator());
        ParseState state = ParseState.newInstance().pushContext(Context.GLOBAL).withCommand(command);
        while (tokens.hasNext()) {
            state = this.parseOptions((PeekingIterator<String>)tokens, state, command.getCommandOptions());
            state = this.parseArgs(state, (PeekingIterator<String>)tokens, command.getArguments(), command.getDefaultOption());
        }
        return state;
    }

    private ParseState parseOptions(PeekingIterator<String> tokens, ParseState state, List<OptionMetadata> allowedOptions) {
        while (tokens.hasNext()) {
            ParseState nextState = this.parseSimpleOption(tokens, state, allowedOptions);
            if (nextState != null) {
                state = nextState;
                continue;
            }
            nextState = this.parseLongGnuGetOpt(tokens, state, allowedOptions);
            if (nextState != null) {
                state = nextState;
                continue;
            }
            nextState = this.parseClassicGetOpt(tokens, state, allowedOptions);
            if (nextState == null) break;
            state = nextState;
        }
        return state;
    }

    private ParseState parseSimpleOption(PeekingIterator<String> tokens, ParseState state, List<OptionMetadata> allowedOptions) {
        OptionMetadata option = this.findOption(state, allowedOptions, (String)tokens.peek());
        if (option == null) {
            return null;
        }
        tokens.next();
        state = state.pushContext(Context.OPTION).withOption(option);
        if (option.getArity() == 0) {
            state = state.withOptionValue(option, Boolean.TRUE).popContext();
        } else if (option.getArity() == 1) {
            if (tokens.hasNext()) {
                String tokenStr = (String)tokens.next();
                this.checkValidValue(option, tokenStr);
                Object value = TypeConverter.newInstance().convert(option.getTitle(), option.getJavaType(), tokenStr);
                state = state.withOptionValue(option, value).popContext();
            }
        } else {
            int count;
            ImmutableList.Builder values = ImmutableList.builder();
            boolean hasSeparator = false;
            boolean foundNextOption = false;
            for (count = 0; count < option.getArity() && tokens.hasNext() && !hasSeparator; ++count) {
                String peekedToken = (String)tokens.peek();
                hasSeparator = peekedToken.equals("--");
                boolean bl = foundNextOption = this.findOption(state, allowedOptions, peekedToken) != null;
                if (hasSeparator || foundNextOption) break;
                String tokenStr = (String)tokens.next();
                this.checkValidValue(option, tokenStr);
                values.add(TypeConverter.newInstance().convert(option.getTitle(), option.getJavaType(), tokenStr));
            }
            if (count == option.getArity() || hasSeparator || foundNextOption) {
                state = state.withOptionValue(option, values.build()).popContext();
            }
        }
        return state;
    }

    private ParseState parseLongGnuGetOpt(PeekingIterator<String> tokens, ParseState state, List<OptionMetadata> allowedOptions) {
        ImmutableList parts = ImmutableList.copyOf((Iterable)Splitter.on((char)'=').limit(2).split((CharSequence)tokens.peek()));
        if (parts.size() != 2) {
            return null;
        }
        OptionMetadata option = this.findOption(state, allowedOptions, (String)parts.get(0));
        if (option == null || option.getArity() != 1) {
            return null;
        }
        tokens.next();
        state = state.pushContext(Context.OPTION).withOption(option);
        this.checkValidValue(option, (String)parts.get(1));
        Object value = TypeConverter.newInstance().convert(option.getTitle(), option.getJavaType(), (String)parts.get(1));
        state = state.withOption(option).withOptionValue(option, value).popContext();
        return state;
    }

    private ParseState parseClassicGetOpt(PeekingIterator<String> tokens, ParseState state, List<OptionMetadata> allowedOptions) {
        if (!SHORT_OPTIONS_PATTERN.matcher((CharSequence)tokens.peek()).matches()) {
            return null;
        }
        String remainingToken = ((String)tokens.peek()).substring(1);
        ParseState nextState = state;
        while (!remainingToken.isEmpty()) {
            char tokenCharacter = remainingToken.charAt(0);
            OptionMetadata option = this.findOption(state, allowedOptions, "-" + tokenCharacter);
            if (option == null) {
                return null;
            }
            nextState = nextState.pushContext(Context.OPTION).withOption(option);
            remainingToken = remainingToken.substring(1);
            if (option.getArity() == 0) {
                nextState = nextState.withOptionValue(option, Boolean.TRUE).popContext();
                continue;
            }
            if (option.getArity() == 1) {
                tokens.next();
                if (!remainingToken.isEmpty()) {
                    this.checkValidValue(option, remainingToken);
                    Object value = TypeConverter.newInstance().convert(option.getTitle(), option.getJavaType(), remainingToken);
                    nextState = nextState.withOptionValue(option, value).popContext();
                } else if (tokens.hasNext()) {
                    String tokenStr = (String)tokens.next();
                    this.checkValidValue(option, tokenStr);
                    Object value = TypeConverter.newInstance().convert(option.getTitle(), option.getJavaType(), tokenStr);
                    nextState = nextState.withOptionValue(option, value).popContext();
                }
                return nextState;
            }
            throw new UnsupportedOperationException("Short options style can not be used with option " + option.getAllowedValues());
        }
        tokens.next();
        return nextState;
    }

    private void checkValidValue(OptionMetadata option, String tokenStr) {
        if (option.getAllowedValues() == null) {
            return;
        }
        if (option.getAllowedValues().contains(tokenStr)) {
            return;
        }
        throw new ParseOptionIllegalValueException(option.getTitle(), tokenStr, option.getAllowedValues());
    }

    private ParseState parseArgs(ParseState state, PeekingIterator<String> tokens, ArgumentsMetadata arguments, OptionMetadata defaultOption) {
        if (tokens.hasNext()) {
            if (((String)tokens.peek()).equals("--")) {
                state = state.pushContext(Context.ARGS);
                tokens.next();
                while (tokens.hasNext()) {
                    state = this.parseArg(state, tokens, arguments, null);
                }
            } else {
                state = this.parseArg(state, tokens, arguments, defaultOption);
            }
        }
        return state;
    }

    private ParseState parseArg(ParseState state, PeekingIterator<String> tokens, ArgumentsMetadata arguments, OptionMetadata defaultOption) {
        if (arguments != null) {
            if (arguments.getArity() > 0 && state.getParsedArguments().size() == arguments.getArity()) {
                throw new ParseTooManyArgumentsException("Too many arguments, at most %d arguments are permitted but extra argument %s was encountered", arguments.getArity(), tokens.peek());
            }
            state = state.withArgument(TypeConverter.newInstance().convert(arguments.getTitle().get(0), arguments.getJavaType(), (String)tokens.next()));
        } else if (defaultOption != null) {
            state = state.withOption(defaultOption);
            String tokenStr = (String)tokens.next();
            this.checkValidValue(defaultOption, tokenStr);
            Object value = TypeConverter.newInstance().convert(defaultOption.getTitle(), defaultOption.getJavaType(), tokenStr);
            state = state.withOptionValue(defaultOption, value).popContext();
        } else {
            state = state.withUnparsedInput((String)tokens.next());
        }
        return state;
    }

    private OptionMetadata findOption(ParseState state, List<OptionMetadata> options, final String param) {
        Object findOptionPredicate = state.getGlobal() != null && state.getGlobal().allowsAbbreviatedOptions() ? new AbbreviatedOptionFinder(param, (Collection<OptionMetadata>)options) : new Predicate<OptionMetadata>(){

            public boolean apply(OptionMetadata op) {
                return op.getOptions().contains(param);
            }
        };
        return (OptionMetadata)Iterables.find(options, (Predicate)findOptionPredicate, null);
    }
}

