/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.airline.help;

import io.airlift.airline.help.AbstractUsageGenerator;
import io.airlift.airline.help.CommandUsageGenerator;
import io.airlift.airline.help.UsageHelper;
import io.airlift.airline.model.CommandMetadata;
import io.airlift.airline.model.OptionMetadata;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public abstract class AbstractCommandUsageGenerator
extends AbstractUsageGenerator
implements CommandUsageGenerator {
    private final Comparator<? super Map.Entry<Integer, String>> exitCodeComparator;

    public AbstractCommandUsageGenerator() {
        this(UsageHelper.DEFAULT_OPTION_COMPARATOR);
    }

    public AbstractCommandUsageGenerator(Comparator<? super OptionMetadata> optionComparator) {
        this(optionComparator, (Comparator<? super Map.Entry<Integer, String>>)UsageHelper.DEFAULT_EXIT_CODE_COMPARATOR);
    }

    public AbstractCommandUsageGenerator(Comparator<? super OptionMetadata> optionComparator, Comparator<? super Map.Entry<Integer, String>> exitCodeComparator) {
        super(optionComparator, UsageHelper.DEFAULT_COMMAND_COMPARATOR);
        this.exitCodeComparator = exitCodeComparator;
    }

    @Override
    public void usage(@Nullable String programName, @Nullable String groupName, String commandName, CommandMetadata command) throws IOException {
        this.usage(programName, groupName, commandName, command, System.out);
    }

    protected List<Map.Entry<Integer, String>> sortExitCodes(List<Map.Entry<Integer, String>> exitCodes) {
        if (this.exitCodeComparator != null) {
            exitCodes = new ArrayList<Map.Entry<Integer, String>>(exitCodes);
            Collections.sort(exitCodes, this.exitCodeComparator);
        }
        return exitCodes;
    }
}

