/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.airline.help;

import com.google.common.base.Preconditions;
import io.airlift.airline.help.AbstractGlobalUsageGenerator;
import io.airlift.airline.help.UsagePrinter;
import io.airlift.airline.model.CommandGroupMetadata;
import io.airlift.airline.model.CommandMetadata;
import io.airlift.airline.model.GlobalMetadata;
import io.airlift.airline.model.OptionMetadata;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Comparator;
import javax.annotation.Nullable;

public abstract class AbstractPrintedGlobalUsageGenerator
extends AbstractGlobalUsageGenerator {
    private final int columnSize;

    public AbstractPrintedGlobalUsageGenerator(int columnSize, @Nullable Comparator<? super OptionMetadata> optionComparator, @Nullable Comparator<? super CommandMetadata> commandComparator, @Nullable Comparator<? super CommandGroupMetadata> commandGroupComparator) {
        super(optionComparator, commandComparator, commandGroupComparator);
        Preconditions.checkArgument((columnSize > 0 ? 1 : 0) != 0, (Object)"columnSize must be greater than 0");
        this.columnSize = columnSize;
    }

    protected abstract void usage(GlobalMetadata var1, UsagePrinter var2) throws IOException;

    protected UsagePrinter createUsagePrinter(OutputStream out) {
        Preconditions.checkNotNull((Object)out, (Object)"StringBuilder cannot be null");
        return new UsagePrinter(new OutputStreamWriter(out), this.columnSize);
    }

    @Override
    public void usage(GlobalMetadata global, OutputStream out) throws IOException {
        UsagePrinter printer = this.createUsagePrinter(out);
        this.usage(global, printer);
        printer.flush();
    }
}

