/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.airline.help;

import com.google.common.collect.Lists;
import io.airlift.airline.Arguments;
import io.airlift.airline.Command;
import io.airlift.airline.help.cli.CliCommandGroupUsageGenerator;
import io.airlift.airline.help.cli.CliCommandUsageGenerator;
import io.airlift.airline.help.cli.CliGlobalUsageGenerator;
import io.airlift.airline.help.cli.CliGlobalUsageSummaryGenerator;
import io.airlift.airline.model.CommandGroupMetadata;
import io.airlift.airline.model.CommandMetadata;
import io.airlift.airline.model.GlobalMetadata;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import javax.inject.Inject;

@Command(name="help", description="Display help information")
public class Help
implements Runnable,
Callable<Void> {
    @Inject
    @Nullable
    public GlobalMetadata global;
    @Arguments
    public List<String> command = Lists.newArrayList();

    @Override
    public void run() {
        try {
            Help.help(this.global, this.command);
        }
        catch (IOException e) {
            throw new RuntimeException("Error generating usage documentation", e);
        }
    }

    @Override
    public Void call() {
        this.run();
        return null;
    }

    public static void help(CommandMetadata command) throws IOException {
        Help.help(command, System.out);
    }

    public static void help(CommandMetadata command, OutputStream out) throws IOException {
        new CliCommandUsageGenerator().usage(null, null, command.getName(), command, out);
    }

    public static void help(GlobalMetadata global, List<String> commandNames) throws IOException {
        Help.help(global, commandNames, System.out);
    }

    public static void help(GlobalMetadata global, List<String> commandNames, OutputStream out) throws IOException {
        if (commandNames.isEmpty()) {
            new CliGlobalUsageSummaryGenerator().usage(global, out);
            return;
        }
        String name = commandNames.get(0);
        if (name.equals(global.getName())) {
            new CliGlobalUsageGenerator().usage(global, out);
            return;
        }
        for (CommandMetadata command : global.getDefaultGroupCommands()) {
            if (!name.equals(command.getName())) continue;
            new CliCommandUsageGenerator().usage(global.getName(), null, command.getName(), command, out);
            return;
        }
        for (CommandGroupMetadata group : global.getCommandGroups()) {
            if (!name.endsWith(group.getName())) continue;
            if (commandNames.size() == 1) {
                new CliCommandGroupUsageGenerator().usage(global, group, out);
                return;
            }
            String commandName = commandNames.get(1);
            for (CommandMetadata command : group.getCommands()) {
                if (!commandName.equals(command.getName())) continue;
                new CliCommandUsageGenerator().usage(global.getName(), group.getName(), command.getName(), command, out);
                return;
            }
            System.out.println("Unknown command " + name + " " + commandName);
        }
        System.out.println("Unknown command " + name);
    }
}

