/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.airline.help.cli;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.airlift.airline.help.AbstractPrintedCommandUsageGenerator;
import io.airlift.airline.help.UsageHelper;
import io.airlift.airline.help.UsagePrinter;
import io.airlift.airline.model.ArgumentsMetadata;
import io.airlift.airline.model.CommandMetadata;
import io.airlift.airline.model.OptionMetadata;
import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class CliCommandUsageGenerator
extends AbstractPrintedCommandUsageGenerator {
    public CliCommandUsageGenerator() {
        this(79, UsageHelper.DEFAULT_OPTION_COMPARATOR);
    }

    public CliCommandUsageGenerator(int columnSize) {
        this(columnSize, UsageHelper.DEFAULT_OPTION_COMPARATOR);
    }

    public CliCommandUsageGenerator(int columnSize, @Nullable Comparator<? super OptionMetadata> optionComparator) {
        super(columnSize, optionComparator);
    }

    @Override
    protected void usage(@Nullable String programName, @Nullable String groupName, String commandName, CommandMetadata command, UsagePrinter out) throws IOException {
        out.append("NAME").newline();
        out.newIndentedPrinter(8).append(programName).append(groupName).append(commandName).append("-").append(command.getDescription()).newline().newline();
        out.append("SYNOPSIS").newline();
        UsagePrinter synopsis = out.newIndentedPrinter(8).newPrinterWithHangingIndent(8);
        List<Object> options = Lists.newArrayList();
        if (programName != null) {
            synopsis.append(programName).appendWords(this.toSynopsisUsage(this.sortOptions(command.getGlobalOptions())));
            options.addAll(command.getGlobalOptions());
        }
        if (groupName != null) {
            synopsis.append(groupName).appendWords(this.toSynopsisUsage(this.sortOptions(command.getGroupOptions())));
            options.addAll(command.getGroupOptions());
        }
        synopsis.append(commandName).appendWords(this.toSynopsisUsage(this.sortOptions(command.getCommandOptions())));
        options.addAll(command.getCommandOptions());
        ArgumentsMetadata arguments = command.getArguments();
        if (arguments != null) {
            synopsis.append("[--]").append(this.toUsage(arguments));
        }
        synopsis.newline();
        synopsis.newline();
        if (options.size() > 0 || arguments != null) {
            options = this.sortOptions((List<OptionMetadata>)options);
            out.append("OPTIONS").newline();
            for (OptionMetadata optionMetadata : options) {
                if (optionMetadata.isHidden()) continue;
                UsagePrinter optionPrinter = out.newIndentedPrinter(8);
                optionPrinter.append(this.toDescription(optionMetadata)).newline();
                optionPrinter.flush();
                UsagePrinter descriptionPrinter = optionPrinter.newIndentedPrinter(4);
                descriptionPrinter.append(optionMetadata.getDescription()).newline();
                if (optionMetadata.getAllowedValues() != null && optionMetadata.getAllowedValues().size() > 0 && optionMetadata.getArity() >= 1) {
                    descriptionPrinter.newline();
                    descriptionPrinter.append("This options value");
                    if (optionMetadata.getArity() == 1) {
                        descriptionPrinter.append(" is ");
                    } else {
                        descriptionPrinter.append("s are ");
                    }
                    descriptionPrinter.append("restricted to the following value(s):").newline();
                    UsagePrinter allowedValuesPrinter = descriptionPrinter.newIndentedPrinter(4);
                    for (String value : optionMetadata.getAllowedValues()) {
                        allowedValuesPrinter.append(value).newline();
                    }
                    allowedValuesPrinter.flush();
                }
                descriptionPrinter.newline();
                descriptionPrinter.flush();
            }
            if (arguments != null) {
                UsagePrinter optionPrinter = out.newIndentedPrinter(8);
                optionPrinter.append("--").newline();
                optionPrinter.flush();
                UsagePrinter usagePrinter = optionPrinter.newIndentedPrinter(4);
                usagePrinter.append("This option can be used to separate command-line options from the list of argument, (useful when arguments might be mistaken for command-line options)").newline();
                usagePrinter.newline();
                optionPrinter.append(this.toDescription(arguments)).newline();
                usagePrinter.append(arguments.getDescription()).newline();
                usagePrinter.newline();
                usagePrinter.flush();
            }
        }
        if (command.getDiscussion() != null) {
            out.append("DISCUSSION").newline();
            UsagePrinter discussionPrinter = out.newIndentedPrinter(8);
            discussionPrinter.append(command.getDiscussion()).newline().newline();
            discussionPrinter.flush();
        }
        if (command.getExamples() != null && !command.getExamples().isEmpty()) {
            out.append("EXAMPLES").newline();
            UsagePrinter examplePrinter = out.newIndentedPrinter(8);
            examplePrinter.appendTable(Iterables.partition(command.getExamples(), (int)1));
            examplePrinter.flush();
        }
        if (command.getExitCodes() != null && !command.getExitCodes().isEmpty()) {
            out.append("EXIT STATUS").newline();
            out.flush();
            UsagePrinter exitPrinter = out.newIndentedPrinter(8);
            exitPrinter.append("The ");
            if (programName != null) {
                exitPrinter.append(programName).append(" ");
            }
            if (groupName != null) {
                exitPrinter.append(groupName).append(" ");
            }
            exitPrinter.append(commandName).append(" command exits with one of the following values:").newline().newline();
            for (Map.Entry<Integer, String> exit : this.sortExitCodes(Lists.newArrayList(command.getExitCodes().entrySet()))) {
                exitPrinter.append(exit.getKey().toString());
                exitPrinter.newline();
                exitPrinter.flush();
                if (!StringUtils.isEmpty((CharSequence)exit.getValue())) {
                    UsagePrinter exitDescripPrinter = exitPrinter.newIndentedPrinter(4);
                    exitDescripPrinter.append(exit.getValue());
                    exitDescripPrinter.flush();
                }
                exitPrinter.newline();
                exitPrinter.flush();
            }
        }
    }
}

