/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.airline.help.html;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import io.airlift.airline.help.AbstractCommandUsageGenerator;
import io.airlift.airline.help.UsageHelper;
import io.airlift.airline.model.ArgumentsMetadata;
import io.airlift.airline.model.CommandMetadata;
import io.airlift.airline.model.OptionMetadata;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class HtmlCommandUsageGenerator
extends AbstractCommandUsageGenerator {
    public static final String DEFAULT_STYLESHEET = "css/bootstrap.min.css";
    protected final List<String> stylesheetUrls = Lists.newArrayList();

    public HtmlCommandUsageGenerator() {
        this(DEFAULT_STYLESHEET);
    }

    public HtmlCommandUsageGenerator(Comparator<? super OptionMetadata> optionComparator) {
        this(optionComparator, DEFAULT_STYLESHEET);
    }

    public HtmlCommandUsageGenerator(String stylesheetUrl) {
        this(stylesheetUrl, UsageHelper.DEFAULT_OPTION_COMPARATOR);
    }

    public HtmlCommandUsageGenerator(String stylesheetUrl, Comparator<OptionMetadata> optionComparator) {
        this(optionComparator, stylesheetUrl);
    }

    public HtmlCommandUsageGenerator(Comparator<? super OptionMetadata> optionComparator, String ... stylesheetUrls) {
        super(optionComparator);
        if (stylesheetUrls != null) {
            for (String stylesheet : stylesheetUrls) {
                if (!StringUtils.isNotEmpty((CharSequence)stylesheet)) continue;
                this.stylesheetUrls.add(stylesheet);
            }
        }
    }

    protected void addAdditionalCss(Writer writer) throws IOException {
        writer.append("    body { margin: 50px; }\n");
    }

    @Override
    public void usage(@Nullable String programName, @Nullable String groupName, String commandName, CommandMetadata command, OutputStream output) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(output);
        String NEWLINE = "<br/>\n";
        ((Writer)writer).append("<html>\n");
        this.createHtmlHead(writer);
        ((Writer)writer).append("<body>\n");
        this.createPageHeader(programName, groupName, command, writer);
        ((Writer)writer).append("<h1 class=\"text-info\">NAME</h1>\n").append("<br/>\n");
        ((Writer)writer).append("<div class=\"row\">");
        ((Writer)writer).append("<div class=\"span8 offset1\">");
        ((Writer)writer).append(programName).append(" ");
        ((Writer)writer).append(groupName).append(" ");
        ((Writer)writer).append(command.getName()).append(" ");
        ((Writer)writer).append("&mdash;");
        ((Writer)writer).append(this.htmlize(command.getDescription()));
        ((Writer)writer).append("</div>\n");
        ((Writer)writer).append("</div>\n");
        ((Writer)writer).append("<br/>\n");
        ((Writer)writer).append("<h1 class=\"text-info\">SYNOPSIS</h1>\n").append("<br/>\n");
        List<Object> options = Lists.newArrayList();
        ((Writer)writer).append("<div class=\"row\">\n");
        ((Writer)writer).append("<div class=\"span8 offset1\">\n");
        if (programName != null) {
            ((Writer)writer).append(programName).append(" ").append(this.htmlize(Joiner.on((String)" ").join(this.toSynopsisUsage(this.sortOptions(command.getGlobalOptions())))));
            options.addAll(command.getGlobalOptions());
        }
        if (groupName != null) {
            ((Writer)writer).append(groupName).append(" ").append(this.htmlize(Joiner.on((String)" ").join(this.toSynopsisUsage(this.sortOptions(command.getGroupOptions())))));
            options.addAll(command.getGroupOptions());
        }
        ((Writer)writer).append(command.getName()).append(" ").append(this.htmlize(Joiner.on((String)" ").join(this.toSynopsisUsage(this.sortOptions(command.getCommandOptions())))));
        options.addAll(command.getCommandOptions());
        ArgumentsMetadata arguments = command.getArguments();
        if (arguments != null) {
            ((Writer)writer).append(" [--] ").append(this.htmlize(this.toUsage(arguments)));
        }
        ((Writer)writer).append("</div>\n");
        ((Writer)writer).append("</div>\n");
        if (options.size() > 0 || arguments != null) {
            options = this.sortOptions((List<OptionMetadata>)options);
            ((Writer)writer).append("<br/>\n");
            ((Writer)writer).append("<h1 class=\"text-info\">OPTIONS</h1>\n").append("<br/>\n");
            for (OptionMetadata optionMetadata : options) {
                if (optionMetadata.isHidden()) continue;
                ((Writer)writer).append("<div class=\"row\">\n");
                ((Writer)writer).append("<div class=\"span8 offset1\">\n");
                ((Writer)writer).append(this.htmlize(this.toDescription(optionMetadata)));
                ((Writer)writer).append("</div>\n");
                ((Writer)writer).append("</div>\n");
                ((Writer)writer).append("<div class=\"row\">\n");
                ((Writer)writer).append("<div class=\"span8 offset2\">\n");
                ((Writer)writer).append(this.htmlize(optionMetadata.getDescription()));
                ((Writer)writer).append("</div>\n");
                ((Writer)writer).append("</div>\n");
                if (optionMetadata.getAllowedValues() == null || optionMetadata.getAllowedValues().size() <= 0 || optionMetadata.getArity() < 1) continue;
                ((Writer)writer).append("<div class=\"row\">\n");
                ((Writer)writer).append("<div class=\"span8 offset3\">\n");
                ((Writer)writer).append("This options value");
                if (optionMetadata.getArity() == 1) {
                    ((Writer)writer).append(" is ");
                } else {
                    ((Writer)writer).append("s are ");
                }
                ((Writer)writer).append("restricted to the following value(s):\n");
                ((Writer)writer).append("<ul>");
                for (String value : optionMetadata.getAllowedValues()) {
                    ((Writer)writer).append("<li>").append(value).append("</li>\n");
                }
                ((Writer)writer).append("</ul>");
                ((Writer)writer).append("</div>\n");
                ((Writer)writer).append("</div>\n");
            }
            if (arguments != null) {
                ((Writer)writer).append("<div class=\"row\">\n");
                ((Writer)writer).append("<div class=\"span8 offset1\">\n");
                ((Writer)writer).append("--\n");
                ((Writer)writer).append("</div>\n");
                ((Writer)writer).append("</div>\n");
                ((Writer)writer).append("<div class=\"row\">\n");
                ((Writer)writer).append("<div class=\"span8 offset2\">\n");
                ((Writer)writer).append("This option can be used to separate command-line options from the list of argument, (useful when arguments might be mistaken for command-line options)\n");
                ((Writer)writer).append("</div>\n");
                ((Writer)writer).append("</div>\n");
                ((Writer)writer).append("<div class=\"row\">\n");
                ((Writer)writer).append("<div class=\"span8 offset1\">\n");
                ((Writer)writer).append(this.htmlize(this.toDescription(arguments)));
                ((Writer)writer).append("</div>\n");
                ((Writer)writer).append("</div>\n");
                ((Writer)writer).append("<div class=\"row\">\n");
                ((Writer)writer).append("<div class=\"span8 offset2\">\n");
                ((Writer)writer).append(this.htmlize(arguments.getDescription()));
                ((Writer)writer).append("</div>\n");
                ((Writer)writer).append("</div>\n");
            }
        }
        if (command.getDiscussion() != null) {
            ((Writer)writer).append("<br/>\n");
            ((Writer)writer).append("<h1 class=\"text-info\">DISCUSSION</h1>\n").append("<br/>\n");
            ((Writer)writer).append("<div class=\"row\">\n");
            ((Writer)writer).append("<div class=\"span8 offset1\">\n");
            ((Writer)writer).append(this.htmlize(command.getDiscussion()));
            ((Writer)writer).append("</div>\n");
            ((Writer)writer).append("</div>\n");
        }
        if (command.getExamples() != null && !command.getExamples().isEmpty()) {
            ((Writer)writer).append("<br/>\n");
            ((Writer)writer).append("<h1 class=\"text-info\">EXAMPLES</h1>\n").append("<br/>\n");
            ((Writer)writer).append("<div class=\"row\">\n");
            ((Writer)writer).append("<div class=\"span12 offset1\">\n");
            for (String string : command.getExamples()) {
                ((Writer)writer).append("<p>\n");
                ((Writer)writer).append(string);
                ((Writer)writer).append("</p>\n");
            }
            ((Writer)writer).append("</div>\n");
            ((Writer)writer).append("</div>\n");
        }
        if (command.getExitCodes() != null && !command.getExitCodes().isEmpty()) {
            ((Writer)writer).append("<br/>\n");
            ((Writer)writer).append("<h1 class=\"text-info\">EXIT STATUS</h1>\n").append("<br/>\n");
            ((Writer)writer).append("<p>\n");
            ((Writer)writer).append("  The ");
            if (programName != null) {
                ((Writer)writer).append(programName).append(" ");
            }
            if (groupName != null) {
                ((Writer)writer).append(groupName).append(" ");
            }
            ((Writer)writer).append(commandName).append(" command exits with one of the following values:");
            ((Writer)writer).append("</p>\n");
            for (Map.Entry entry : this.sortExitCodes(Lists.newArrayList(command.getExitCodes().entrySet()))) {
                ((Writer)writer).append("<div class=\"row\">\n");
                ((Writer)writer).append("<div class=\"span8 offset1\">\n");
                ((Writer)writer).append(((Integer)entry.getKey()).toString());
                if (!StringUtils.isEmpty((CharSequence)((CharSequence)entry.getValue()))) {
                    ((Writer)writer).append("</div>\n");
                    ((Writer)writer).append("</div>\n");
                    ((Writer)writer).append("<div class=\"row\">\n");
                    ((Writer)writer).append("<div class=\"span8 offset2\">\n");
                    ((Writer)writer).append(this.htmlize((String)entry.getValue()));
                    ((Writer)writer).append("</div>\n");
                    ((Writer)writer).append("</div>\n");
                    continue;
                }
                ((Writer)writer).append("</div>\n");
                ((Writer)writer).append("</div>\n");
            }
        }
        ((Writer)writer).append("</body>\n");
        ((Writer)writer).append("</html>\n");
        ((Writer)writer).flush();
        output.flush();
    }

    protected void createPageHeader(String programName, String groupName, CommandMetadata command, Writer writer) throws IOException {
        writer.append("<hr/>\n");
        writer.append("<h1 class=\"text-info\">").append(programName).append(" ").append(groupName).append(" ").append(command.getName()).append(" Manual Page\n");
        writer.append("<hr/>\n");
    }

    protected void createHtmlHead(Writer writer) throws IOException {
        writer.append("<head>\n");
        for (String stylesheet : this.stylesheetUrls) {
            writer.append("<link href=\"").append(stylesheet).append("\" rel=\"stylesheet\">\n");
        }
        writer.append("<style>\n");
        this.addAdditionalCss(writer);
        writer.append("</style>\n");
        writer.append("</head>\n");
    }
}

