/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.airline.help.ronn;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.airlift.airline.help.AbstractCommandUsageGenerator;
import io.airlift.airline.model.ArgumentsMetadata;
import io.airlift.airline.model.CommandMetadata;
import io.airlift.airline.model.OptionMetadata;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class RonnCommandUsageGenerator
extends AbstractCommandUsageGenerator {
    private final int manSection;
    private final boolean standalone;

    public RonnCommandUsageGenerator() {
        this(1, true);
    }

    public RonnCommandUsageGenerator(int manSection, boolean standalone) {
        this.manSection = manSection;
        this.standalone = standalone;
    }

    @Override
    public void usage(@Nullable String programName, @Nullable String groupName, String commandName, CommandMetadata command, OutputStream output) throws IOException {
        List<OptionMetadata> aOptions;
        String NEW_PARA = "\n\n";
        String SECTION_HEADER = "## ";
        if (commandName == null) {
            commandName = command.getName();
        }
        OutputStreamWriter writer = new OutputStreamWriter(output);
        if (!this.standalone) {
            ((Writer)writer).append(SECTION_HEADER);
            SECTION_HEADER = "#" + SECTION_HEADER;
        }
        this.writeFullCommandName(programName, groupName, commandName, writer);
        if (this.standalone) {
            ((Writer)writer).append(" -- ");
            ((Writer)writer).append(command.getDescription()).append("\n");
            ((Writer)writer).append("==========");
        }
        ((Writer)writer).append("\n\n").append(SECTION_HEADER).append("SYNOPSIS").append("\n\n");
        List<Object> options = Lists.newArrayList();
        if (programName != null) {
            ((Writer)writer).append("`").append(programName).append("`");
            aOptions = command.getGlobalOptions();
            if (aOptions != null && aOptions.size() > 0) {
                ((Writer)writer).append(" ").append(Joiner.on((String)" ").join(this.toSynopsisUsage(this.sortOptions(aOptions))));
                options.addAll(aOptions);
            }
        }
        if (groupName != null) {
            ((Writer)writer).append(" `").append(groupName).append("`");
            aOptions = command.getGroupOptions();
            if (aOptions != null && aOptions.size() > 0) {
                ((Writer)writer).append(" ").append(Joiner.on((String)" ").join(this.toSynopsisUsage(this.sortOptions(aOptions))));
                options.addAll(aOptions);
            }
        }
        aOptions = command.getCommandOptions();
        ((Writer)writer).append(" `").append(commandName).append("` ").append(Joiner.on((String)" ").join(this.toSynopsisUsage(this.sortOptions(aOptions))));
        options.addAll(aOptions);
        ArgumentsMetadata arguments = command.getArguments();
        if (arguments != null) {
            ((Writer)writer).append(" [--] ").append(this.toUsage(arguments));
        }
        if (!this.standalone) {
            ((Writer)writer).append("\n\n").append(command.getDescription());
        }
        if (options.size() > 0 || arguments != null) {
            ((Writer)writer).append("\n\n").append(SECTION_HEADER).append("OPTIONS");
            options = this.sortOptions((List<OptionMetadata>)options);
            for (OptionMetadata optionMetadata : options) {
                if (optionMetadata.isHidden()) continue;
                ((Writer)writer).append("\n\n").append("* ").append(this.toDescription(optionMetadata)).append(":\n");
                ((Writer)writer).append(optionMetadata.getDescription());
                if (optionMetadata.getAllowedValues() == null || optionMetadata.getAllowedValues().size() <= 0 || optionMetadata.getArity() < 1) continue;
                ((Writer)writer).append("\n\n").append("  This options value");
                if (optionMetadata.getArity() == 1) {
                    ((Writer)writer).append(" is ");
                } else {
                    ((Writer)writer).append("s are ");
                }
                ((Writer)writer).append("restricted to the following value(s): [");
                boolean first = true;
                for (String value : optionMetadata.getAllowedValues()) {
                    if (first) {
                        first = false;
                    } else {
                        ((Writer)writer).append(", ");
                    }
                    ((Writer)writer).append(value);
                }
                ((Writer)writer).append("]");
            }
            if (arguments != null) {
                ((Writer)writer).append("\n\n").append("* `--`:\n");
                ((Writer)writer).append("This option can be used to separate command-line options from the list of arguments (useful when arguments might be mistaken for command-line options).");
                ((Writer)writer).append("\n\n").append("* ").append(this.toDescription(arguments)).append(":\n");
                ((Writer)writer).append(arguments.getDescription());
            }
        }
        if (command.getDiscussion() != null) {
            ((Writer)writer).append("\n\n").append(SECTION_HEADER).append("DISCUSSION").append("\n\n");
            ((Writer)writer).append(command.getDiscussion());
        }
        if (command.getExamples() != null && !command.getExamples().isEmpty()) {
            ((Writer)writer).append("\n\n").append(SECTION_HEADER).append("EXAMPLES");
            for (String string : command.getExamples()) {
                ((Writer)writer).append("\n\n").append(string);
            }
        }
        if (command.getExitCodes() != null && !command.getExitCodes().isEmpty()) {
            ((Writer)writer).append("\n\n").append(SECTION_HEADER).append("EXIT STATUS");
            ((Writer)writer).append("\n\n").append("The `");
            this.writeFullCommandName(programName, groupName, commandName, writer);
            ((Writer)writer).append("` command exits with one of the following values:");
            ((Writer)writer).append("\n\n");
            for (Map.Entry entry : this.sortExitCodes(Lists.newArrayList(command.getExitCodes().entrySet()))) {
                ((Writer)writer).append("* **").append(((Integer)entry.getKey()).toString()).append("**");
                if (!StringUtils.isEmpty((CharSequence)((CharSequence)entry.getValue()))) {
                    ((Writer)writer).append(" - ").append((CharSequence)entry.getValue());
                }
                writer.append('\n');
            }
        }
        ((Writer)writer).flush();
        output.flush();
    }

    protected void writeFullCommandName(String programName, String groupName, String commandName, Writer writer) throws IOException {
        if (programName != null) {
            writer.append(programName).append("-");
        }
        if (groupName != null) {
            writer.append(groupName).append("-");
        }
        writer.append(commandName).append("(").append(Integer.toString(this.manSection)).append(")");
    }

    @Override
    protected String toDescription(OptionMetadata option) {
        Set<String> options = option.getOptions();
        StringBuilder stringBuilder = new StringBuilder();
        final String argumentString = option.getArity() > 0 ? Joiner.on((String)" ").join((Iterable)Lists.transform((List)ImmutableList.of((Object)option.getTitle()), (Function)new Function<String, String>(){

            public String apply(@Nullable String argument) {
                return "<" + argument + ">";
            }
        })) : null;
        Joiner.on((String)", ").appendTo(stringBuilder, Iterables.transform(options, (Function)new Function<String, String>(){

            public String apply(@Nullable String option) {
                if (argumentString != null) {
                    return "`" + option + "` " + argumentString;
                }
                return "`" + option + "`";
            }
        }));
        return stringBuilder.toString();
    }
}

