/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.airline.help.ronn;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.airlift.airline.help.AbstractGlobalUsageGenerator;
import io.airlift.airline.help.CommandUsageGenerator;
import io.airlift.airline.help.ronn.RonnCommandUsageGenerator;
import io.airlift.airline.model.CommandGroupMetadata;
import io.airlift.airline.model.CommandMetadata;
import io.airlift.airline.model.GlobalMetadata;
import io.airlift.airline.model.OptionMetadata;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;

public class RonnGlobalUsageGenerator
extends AbstractGlobalUsageGenerator {
    protected final CommandUsageGenerator commandUsageGenerator;
    protected final int manSection;
    protected static final String NEW_PARA = "\n\n";
    protected static final String HORIZONTAL_RULE = "---";

    public RonnGlobalUsageGenerator() {
        this(1, new RonnCommandUsageGenerator(1, false));
    }

    public RonnGlobalUsageGenerator(int manSection) {
        this(manSection, new RonnCommandUsageGenerator(manSection, false));
    }

    protected RonnGlobalUsageGenerator(int manSection, CommandUsageGenerator commandUsageGenerator) {
        this.commandUsageGenerator = commandUsageGenerator;
        this.manSection = manSection;
    }

    @Override
    public void usage(GlobalMetadata global, OutputStream output) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(output);
        ((Writer)writer).append(global.getName()).append("(").append(Integer.toString(this.manSection)).append(") -- ");
        ((Writer)writer).append(global.getDescription()).append("\n");
        ((Writer)writer).append("==========");
        ((Writer)writer).append(NEW_PARA).append("## SYNOPSIS").append(NEW_PARA);
        List<Object> options = Lists.newArrayList();
        ((Writer)writer).append("`").append(global.getName()).append("`");
        List<OptionMetadata> aOptions = global.getOptions();
        if (aOptions != null && aOptions.size() > 0) {
            ((Writer)writer).append(" ").append(Joiner.on((String)" ").join(this.toSynopsisUsage(this.sortOptions(aOptions))));
            options.addAll(aOptions);
        }
        if (global.getCommandGroups().size() > 0) {
            ((Writer)writer).append(" [<group>] <command> [command-args]");
        } else {
            ((Writer)writer).append(" <command> [command-args]");
        }
        if (options.size() > 0) {
            ((Writer)writer).append(NEW_PARA).append("## GLOBAL OPTIONS");
            options = this.sortOptions((List<OptionMetadata>)options);
            for (OptionMetadata optionMetadata : options) {
                if (optionMetadata.isHidden()) continue;
                ((Writer)writer).append(NEW_PARA).append("* ").append(this.toDescription(optionMetadata)).append(":\n");
                ((Writer)writer).append(optionMetadata.getDescription());
                if (optionMetadata.getAllowedValues() == null || optionMetadata.getAllowedValues().size() <= 0 || optionMetadata.getArity() < 1) continue;
                ((Writer)writer).append(NEW_PARA).append("  This options value");
                if (optionMetadata.getArity() == 1) {
                    ((Writer)writer).append(" is ");
                } else {
                    ((Writer)writer).append("s are ");
                }
                ((Writer)writer).append("restricted to the following value(s): [");
                boolean first = true;
                for (String value : optionMetadata.getAllowedValues()) {
                    if (first) {
                        first = false;
                    } else {
                        ((Writer)writer).append(", ");
                    }
                    ((Writer)writer).append(value);
                }
                ((Writer)writer).append("]");
            }
        }
        ((Writer)writer).flush();
        output.flush();
        if (global.getCommandGroups().size() > 0) {
            ((Writer)writer).append(NEW_PARA).append("## COMMAND GROUPS").append(NEW_PARA);
            ((Writer)writer).append("Commands are grouped as follows:");
            if (global.getDefaultGroupCommands().size() > 0) {
                ((Writer)writer).append(NEW_PARA).append("* Default (no <group> specified)");
                for (CommandMetadata commandMetadata : this.sortCommands(global.getDefaultGroupCommands())) {
                    if (commandMetadata.isHidden()) continue;
                    ((Writer)writer).append(NEW_PARA).append("  * `").append(this.getCommandName(global, null, commandMetadata)).append("`:\n");
                    ((Writer)writer).append("  ").append(commandMetadata.getDescription());
                }
            }
            for (CommandGroupMetadata commandGroupMetadata : this.sortCommandGroups(global.getCommandGroups())) {
                ((Writer)writer).append(NEW_PARA).append("* **").append(commandGroupMetadata.getName()).append("**").append(NEW_PARA);
                ((Writer)writer).append("  ").append(commandGroupMetadata.getDescription());
                for (CommandMetadata command : this.sortCommands(commandGroupMetadata.getCommands())) {
                    if (command.isHidden()) continue;
                    ((Writer)writer).append(NEW_PARA).append("  * `").append(this.getCommandName(global, commandGroupMetadata.getName(), command)).append("`:\n");
                    ((Writer)writer).append("  ").append(command.getDescription());
                }
            }
            this.outputCommandUsages(global, output, writer);
        } else {
            ((Writer)writer).append(NEW_PARA).append("## COMMANDS");
            for (CommandMetadata commandMetadata : this.sortCommands(global.getDefaultGroupCommands())) {
                if (commandMetadata.isHidden()) continue;
                ((Writer)writer).append(NEW_PARA).append("* `").append(this.getCommandName(global, null, commandMetadata)).append("`:\n");
                ((Writer)writer).append(commandMetadata.getDescription());
            }
            this.outputCommandUsages(global, output, writer);
        }
        ((Writer)writer).flush();
        output.flush();
    }

    protected void outputCommandUsages(GlobalMetadata global, OutputStream output, Writer writer) throws IOException {
        writer.append(NEW_PARA).append(HORIZONTAL_RULE).append(NEW_PARA);
        this.outputDefaultGroupCommandUsages(global, output, writer);
        for (CommandGroupMetadata group : this.sortCommandGroups(global.getCommandGroups())) {
            this.outputGroupCommandUsages(global, output, writer, group);
        }
    }

    protected String getCommandName(GlobalMetadata global, String groupName, CommandMetadata command) {
        return command.getName();
    }

    protected void outputGroupCommandUsages(GlobalMetadata global, OutputStream output, Writer writer, CommandGroupMetadata group) throws IOException {
        for (CommandMetadata command : this.sortCommands(group.getCommands())) {
            if (command.isHidden()) continue;
            writer.flush();
            output.flush();
            this.commandUsageGenerator.usage(global.getName(), group.getName(), command.getName(), command, output);
            writer.append(NEW_PARA).append(HORIZONTAL_RULE).append(NEW_PARA);
        }
    }

    protected void outputDefaultGroupCommandUsages(GlobalMetadata global, OutputStream output, Writer writer) throws IOException {
        for (CommandMetadata command : this.sortCommands(global.getDefaultGroupCommands())) {
            if (command.isHidden()) continue;
            writer.flush();
            output.flush();
            this.commandUsageGenerator.usage(global.getName(), null, command.getName(), command, output);
            writer.append(NEW_PARA).append(HORIZONTAL_RULE).append(NEW_PARA);
        }
    }

    @Override
    protected String toDescription(OptionMetadata option) {
        Set<String> options = option.getOptions();
        StringBuilder stringBuilder = new StringBuilder();
        final String argumentString = option.getArity() > 0 ? Joiner.on((String)" ").join((Iterable)Lists.transform((List)ImmutableList.of((Object)option.getTitle()), (Function)new Function<String, String>(){

            public String apply(@Nullable String argument) {
                return "<" + argument + ">";
            }
        })) : null;
        Joiner.on((String)", ").appendTo(stringBuilder, Iterables.transform(options, (Function)new Function<String, String>(){

            public String apply(@Nullable String option) {
                if (argumentString != null) {
                    return "`" + option + "` " + argumentString;
                }
                return "`" + option + "`";
            }
        }));
        return stringBuilder.toString();
    }
}

