/**
 * Copyright (C) 2010 the original author or authors.
 * See the notice.md file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.github.rvesse.airline.parser;

/**
 * Super class of all command line parsing exceptions
 *
 */
public class ParseException extends RuntimeException
{
    private static final long serialVersionUID = 3772132549207742875L;

    public ParseException(String string, Object... args)
    {
        super(String.format(string, args));
    }

    public ParseException(Exception cause, String string, Object... args)
    {
        super(String.format(string, args), cause);
    }
}
