/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline;

import com.github.rvesse.airline.CommandFactory;
import com.github.rvesse.airline.Context;
import com.github.rvesse.airline.TypeConverter;
import com.github.rvesse.airline.builder.AliasBuilder;
import com.github.rvesse.airline.builder.CliBuilder;
import com.github.rvesse.airline.builder.GroupBuilder;
import com.github.rvesse.airline.model.AliasMetadata;
import com.github.rvesse.airline.model.ArgumentsMetadata;
import com.github.rvesse.airline.model.CommandGroupMetadata;
import com.github.rvesse.airline.model.CommandMetadata;
import com.github.rvesse.airline.model.GlobalMetadata;
import com.github.rvesse.airline.model.MetadataLoader;
import com.github.rvesse.airline.model.OptionMetadata;
import com.github.rvesse.airline.parser.ParseArgumentsMissingException;
import com.github.rvesse.airline.parser.ParseArgumentsUnexpectedException;
import com.github.rvesse.airline.parser.ParseCommandMissingException;
import com.github.rvesse.airline.parser.ParseCommandUnrecognizedException;
import com.github.rvesse.airline.parser.ParseOptionMissingException;
import com.github.rvesse.airline.parser.ParseOptionMissingValueException;
import com.github.rvesse.airline.parser.ParseState;
import com.github.rvesse.airline.parser.Parser;
import com.github.rvesse.airline.parser.ParserUtil;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class Cli<C> {
    private final GlobalMetadata metadata;
    private final CommandFactory<C> mCommandFactory;

    public static <T> CliBuilder<T> builder(String name) {
        Preconditions.checkNotNull((Object)name, (Object)"name is null");
        return new CliBuilder(name);
    }

    public Cli(String name, String description, TypeConverter typeConverter, Class<? extends C> defaultCommand, CommandFactory<C> theCommandFactory, Iterable<Class<? extends C>> defaultGroupCommands, Iterable<GroupBuilder<C>> groups, Iterable<AliasBuilder<C>> aliases, boolean aliasesOverrideBuiltIns, boolean allowAbbreviatedCommands, boolean allowAbbreviatedOptions) {
        Preconditions.checkArgument((StringUtils.isNotEmpty((CharSequence)name) && !StringUtils.isWhitespace((CharSequence)name) ? 1 : 0) != 0, (Object)"Program name cannot be null/empty/whitespace");
        Preconditions.checkNotNull((Object)typeConverter, (Object)"typeConverter is null");
        Preconditions.checkNotNull(theCommandFactory, (Object)"theCommandFactory is null");
        this.mCommandFactory = theCommandFactory;
        CommandMetadata defaultCommandMetadata = null;
        if (defaultCommand != null) {
            defaultCommandMetadata = MetadataLoader.loadCommand(defaultCommand);
        }
        ArrayList<CommandMetadata> allCommands = new ArrayList<CommandMetadata>();
        ArrayList defaultCommandGroup = defaultGroupCommands != null ? Lists.newArrayList(MetadataLoader.loadCommands(defaultGroupCommands)) : Lists.newArrayList();
        allCommands.addAll(defaultCommandGroup);
        ArrayList commandGroups = groups != null ? Lists.newArrayList((Iterable)Iterables.transform(groups, (Function)new Function<GroupBuilder<C>, CommandGroupMetadata>(){

            public CommandGroupMetadata apply(GroupBuilder<C> group) {
                return group.build();
            }
        })) : Lists.newArrayList();
        for (CommandGroupMetadata group : commandGroups) {
            allCommands.addAll(group.getCommands());
        }
        MetadataLoader.loadCommandsIntoGroupsByAnnotation(allCommands, commandGroups, defaultCommandGroup);
        ArrayList aliasData = aliases != null ? Lists.newArrayList((Iterable)Iterables.transform(aliases, (Function)new Function<AliasBuilder<C>, AliasMetadata>(){

            public AliasMetadata apply(AliasBuilder<C> input) {
                return input.build();
            }
        })) : Lists.newArrayList();
        Preconditions.checkArgument((allCommands.size() > 0 ? 1 : 0) != 0, (Object)"Must specify at least one command to create a CLI");
        this.metadata = MetadataLoader.loadGlobal(name, description, defaultCommandMetadata, (Iterable<CommandMetadata>)ImmutableList.copyOf((Collection)defaultCommandGroup), (Iterable<CommandGroupMetadata>)ImmutableList.copyOf((Collection)commandGroups), (Iterable<AliasMetadata>)ImmutableList.copyOf((Collection)aliasData), aliasesOverrideBuiltIns, allowAbbreviatedCommands, allowAbbreviatedOptions);
    }

    public GlobalMetadata getMetadata() {
        return this.metadata;
    }

    public C parse(CommandFactory<C> commandFactory, String ... args) {
        return this.parse(commandFactory, (Iterable<String>)ImmutableList.copyOf((Object[])args));
    }

    public C parse(String ... args) {
        return this.parse(this.mCommandFactory, (Iterable<String>)ImmutableList.copyOf((Object[])args));
    }

    public C parse(Iterable<String> args) {
        return this.parse(this.mCommandFactory, args);
    }

    public C parse(CommandFactory<C> commandFactory, Iterable<String> args) {
        Preconditions.checkNotNull(args, (Object)"args is null");
        Parser parser = new Parser();
        ParseState state = parser.parse(this.metadata, args);
        if (state.getCommand() == null) {
            state = state.getGroup() != null ? state.withCommand(state.getGroup().getDefaultCommand()) : state.withCommand(this.metadata.getDefaultCommand());
        }
        this.validate(state);
        CommandMetadata command = state.getCommand();
        ImmutableMap.Builder bindings = ImmutableMap.builder().put(GlobalMetadata.class, (Object)this.metadata);
        if (state.getGroup() != null) {
            bindings.put(CommandGroupMetadata.class, (Object)state.getGroup());
        }
        if (state.getCommand() != null) {
            bindings.put(CommandMetadata.class, (Object)state.getCommand());
        }
        return ParserUtil.createInstance(command.getType(), command.getAllOptions(), state.getParsedOptions(), command.getArguments(), state.getParsedArguments(), command.getMetadataInjections(), bindings.build(), commandFactory);
    }

    public C parse(C commandInstance, String ... args) {
        Preconditions.checkNotNull((Object)args, (Object)"args is null");
        Parser parser = new Parser();
        ParseState state = parser.parse(this.metadata, args);
        CommandMetadata command = MetadataLoader.loadCommand(commandInstance.getClass());
        state = state.withCommand(command);
        this.validate(state);
        ImmutableMap.Builder bindings = ImmutableMap.builder().put(GlobalMetadata.class, (Object)this.metadata);
        if (state.getGroup() != null) {
            bindings.put(CommandGroupMetadata.class, (Object)state.getGroup());
        }
        bindings.put(CommandMetadata.class, (Object)command);
        C c = ParserUtil.injectOptions(commandInstance, command.getAllOptions(), state.getParsedOptions(), command.getArguments(), state.getParsedArguments(), command.getMetadataInjections(), bindings.build());
        return c;
    }

    private void validate(ParseState state) {
        CommandMetadata command = state.getCommand();
        if (command == null) {
            List<String> unparsedInput = state.getUnparsedInput();
            if (unparsedInput.isEmpty()) {
                throw new ParseCommandMissingException();
            }
            throw new ParseCommandUnrecognizedException(unparsedInput);
        }
        ArgumentsMetadata arguments = command.getArguments();
        if (state.getParsedArguments().isEmpty() && arguments != null && arguments.isRequired()) {
            throw new ParseArgumentsMissingException(arguments.getTitle());
        }
        if (!state.getUnparsedInput().isEmpty()) {
            throw new ParseArgumentsUnexpectedException(state.getUnparsedInput());
        }
        if (state.getLocation() == Context.OPTION) {
            throw new ParseOptionMissingValueException(state.getCurrentOption().getTitle());
        }
        for (OptionMetadata option : command.getAllOptions()) {
            if (!option.isRequired() || state.getParsedOptions().containsKey((Object)option)) continue;
            throw new ParseOptionMissingException(option.getOptions().iterator().next());
        }
    }
}

