/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline;

import com.github.rvesse.airline.Option;
import com.github.rvesse.airline.help.CommandUsageGenerator;
import com.github.rvesse.airline.help.cli.CliCommandUsageGenerator;
import com.github.rvesse.airline.model.CommandGroupMetadata;
import com.github.rvesse.airline.model.CommandMetadata;
import com.github.rvesse.airline.model.GlobalMetadata;
import com.google.common.base.Preconditions;
import java.io.IOException;
import javax.inject.Inject;

public class HelpOption {
    @Inject
    private GlobalMetadata globalMetadata;
    @Inject
    private CommandGroupMetadata groupMetadata;
    @Inject
    private CommandMetadata commandMetadata;
    @Option(name={"-h", "--help"}, description="Display help information")
    public Boolean help = false;
    private boolean shown = false;

    public boolean showHelpIfRequested() {
        return this.showHelpIfRequested(new CliCommandUsageGenerator());
    }

    public boolean showHelpIfRequested(CommandUsageGenerator generator) {
        if (this.help.booleanValue() && !this.shown) {
            this.showHelp(generator);
            this.shown = true;
        }
        return this.help;
    }

    public void showHelp() {
        this.showHelp(new CliCommandUsageGenerator());
    }

    public void showHelp(CommandUsageGenerator generator) {
        Preconditions.checkNotNull((Object)generator, (Object)"Usage generator cannot be null");
        try {
            generator.usage(this.globalMetadata != null ? this.globalMetadata.getName() : null, this.groupMetadata != null ? this.groupMetadata.getName() : null, this.commandMetadata.getName(), this.commandMetadata);
        }
        catch (IOException e) {
            throw new RuntimeException("Error generating usage documentation", e);
        }
    }
}

