/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline;

import com.github.rvesse.airline.Context;
import com.github.rvesse.airline.model.ArgumentsMetadata;
import com.github.rvesse.airline.model.CommandMetadata;
import com.github.rvesse.airline.model.MetadataLoader;
import com.github.rvesse.airline.model.OptionMetadata;
import com.github.rvesse.airline.parser.ParseArgumentsMissingException;
import com.github.rvesse.airline.parser.ParseArgumentsUnexpectedException;
import com.github.rvesse.airline.parser.ParseCommandMissingException;
import com.github.rvesse.airline.parser.ParseCommandUnrecognizedException;
import com.github.rvesse.airline.parser.ParseOptionMissingException;
import com.github.rvesse.airline.parser.ParseOptionMissingValueException;
import com.github.rvesse.airline.parser.ParseState;
import com.github.rvesse.airline.parser.Parser;
import com.github.rvesse.airline.parser.ParserUtil;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;

public class SingleCommand<C> {
    private final CommandMetadata commandMetadata;

    public static <C> SingleCommand<C> singleCommand(Class<C> command) {
        return new SingleCommand<C>(command);
    }

    private SingleCommand(Class<C> command) {
        Preconditions.checkNotNull(command, (Object)"command is null");
        this.commandMetadata = MetadataLoader.loadCommand(command);
    }

    public CommandMetadata getCommandMetadata() {
        return this.commandMetadata;
    }

    public C parse(String ... args) {
        return this.parse((Iterable<String>)ImmutableList.copyOf((Object[])args));
    }

    public C parse(Iterable<String> args) {
        Preconditions.checkNotNull(args, (Object)"args is null");
        Parser parser = new Parser();
        ParseState state = parser.parseCommand(this.commandMetadata, args);
        this.validate(state);
        CommandMetadata command = state.getCommand();
        return (C)ParserUtil.createInstance(command.getType(), command.getAllOptions(), state.getParsedOptions(), command.getArguments(), state.getParsedArguments(), command.getMetadataInjections(), ImmutableMap.of(CommandMetadata.class, (Object)this.commandMetadata));
    }

    private void validate(ParseState state) {
        CommandMetadata command = state.getCommand();
        if (command == null) {
            List<String> unparsedInput = state.getUnparsedInput();
            if (unparsedInput.isEmpty()) {
                throw new ParseCommandMissingException();
            }
            throw new ParseCommandUnrecognizedException(unparsedInput);
        }
        ArgumentsMetadata arguments = command.getArguments();
        if (state.getParsedArguments().isEmpty() && arguments != null && arguments.isRequired()) {
            throw new ParseArgumentsMissingException(arguments.getTitle());
        }
        if (!state.getUnparsedInput().isEmpty()) {
            throw new ParseArgumentsUnexpectedException(state.getUnparsedInput());
        }
        if (state.getLocation() == Context.OPTION) {
            throw new ParseOptionMissingValueException(state.getCurrentOption().getTitle());
        }
        for (OptionMetadata option : command.getAllOptions()) {
            if (!option.isRequired() || state.getParsedOptions().containsKey((Object)option)) continue;
            throw new ParseOptionMissingException(option.getOptions().iterator().next());
        }
    }
}

