/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.builder;

import com.github.rvesse.airline.model.AliasMetadata;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class AliasBuilder<C> {
    private final String name;
    private final List<String> arguments = Lists.newArrayList();

    AliasBuilder(String name) {
        Preconditions.checkArgument((StringUtils.isNotEmpty((CharSequence)name) && !StringUtils.isWhitespace((CharSequence)name) ? 1 : 0) != 0, (Object)"Alias name cannot be null/empty/whitespace");
        this.name = name;
    }

    public AliasBuilder<C> withArgument(String arg) {
        Preconditions.checkNotNull((Object)arg, (Object)"Alias argument cannot be null");
        this.arguments.add(arg);
        return this;
    }

    public AliasBuilder<C> withArguments(String ... args) {
        for (String arg : args) {
            Preconditions.checkNotNull((Object)arg, (Object)"Alias argument cannot be null");
            this.arguments.add(arg);
        }
        return this;
    }

    public AliasMetadata build() {
        return new AliasMetadata(this.name, this.arguments);
    }
}

