/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.builder;

import com.github.rvesse.airline.Cli;
import com.github.rvesse.airline.CommandFactory;
import com.github.rvesse.airline.CommandFactoryDefault;
import com.github.rvesse.airline.TypeConverter;
import com.github.rvesse.airline.builder.AbstractBuilder;
import com.github.rvesse.airline.builder.AliasBuilder;
import com.github.rvesse.airline.builder.GroupBuilder;
import com.github.rvesse.airline.parser.AliasArgumentsParser;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public class CliBuilder<C>
extends AbstractBuilder<Cli<C>> {
    protected final String name;
    protected String description;
    protected TypeConverter typeConverter = new TypeConverter();
    protected String optionSeparators;
    private Class<? extends C> defaultCommand;
    private final List<Class<? extends C>> defaultCommandGroupCommands = Lists.newArrayList();
    protected final Map<String, AliasBuilder<C>> aliases = Maps.newHashMap();
    protected final Map<String, GroupBuilder<C>> groups = Maps.newHashMap();
    protected CommandFactory<C> commandFactory = new CommandFactoryDefault<C>();
    protected boolean allowAbbreviatedCommands;
    protected boolean allowAbbreviatedOptions;
    protected boolean aliasesOverrideBuiltIns;

    public CliBuilder(String name) {
        this.checkNotBlank(name, "Program name");
        this.name = name;
    }

    public CliBuilder<C> withDescription(String description) {
        this.checkNotEmpty(description, "Description");
        this.description = description;
        return this;
    }

    public CliBuilder<C> withCommandFactory(CommandFactory<C> commandFactory) {
        this.commandFactory = commandFactory;
        return this;
    }

    public CliBuilder<C> withDefaultCommand(Class<? extends C> defaultCommand) {
        this.defaultCommand = defaultCommand;
        return this;
    }

    public CliBuilder<C> withCommand(Class<? extends C> command) {
        this.defaultCommandGroupCommands.add(command);
        return this;
    }

    public CliBuilder<C> withCommands(Class<? extends C> command, Class<? extends C> ... moreCommands) {
        this.defaultCommandGroupCommands.add(command);
        this.defaultCommandGroupCommands.addAll((Collection<Class<C>>)ImmutableList.copyOf((Object[])moreCommands));
        return this;
    }

    public CliBuilder<C> withCommands(Iterable<Class<? extends C>> commands) {
        this.defaultCommandGroupCommands.addAll((Collection<Class<C>>)ImmutableList.copyOf(commands));
        return this;
    }

    public GroupBuilder<C> withGroup(String name) {
        this.checkNotBlank(name, "Group name");
        if (this.groups.containsKey(name)) {
            return this.groups.get(name);
        }
        GroupBuilder group = new GroupBuilder(name);
        this.groups.put(name, group);
        return group;
    }

    public GroupBuilder<C> getGroup(String name) {
        this.checkNotBlank(name, "Group name");
        Preconditions.checkArgument((boolean)this.groups.containsKey(name), (String)"Group %s has not been declared", (Object[])new Object[]{name});
        return this.groups.get(name);
    }

    public AliasBuilder<C> withAlias(String name) {
        this.checkNotBlank(name, "Alias name");
        if (this.aliases.containsKey(name)) {
            return this.aliases.get(name);
        }
        AliasBuilder alias = new AliasBuilder(name);
        this.aliases.put(name, alias);
        return alias;
    }

    public AliasBuilder<C> getAlias(String name) {
        this.checkNotBlank(name, "Alias name");
        Preconditions.checkArgument((boolean)this.aliases.containsKey(name), (String)"Alias %s has not been declared", (Object[])new Object[]{name});
        return this.aliases.get(name);
    }

    public CliBuilder<C> withUserAliases() throws IOException {
        return this.withUserAliases(this.name + ".config", null, System.getProperty("user.home") + "/." + this.name + "/");
    }

    public CliBuilder<C> withUserAliases(String searchLocation) throws IOException {
        return this.withUserAliases(this.name + ".config", null, searchLocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CliBuilder<C> withUserAliases(String filename, String prefix, String ... searchLocations) throws IOException {
        Properties properties = new Properties();
        for (int i = searchLocations.length - 1; i >= 0; --i) {
            File f = new File(searchLocations[i]);
            if (!(f = new File(f, filename)).exists() || !f.isFile() || !f.canRead()) continue;
            try (FileInputStream input = new FileInputStream(f);){
                properties.load(input);
                continue;
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)prefix)) {
            ArrayList<Object> keysToRemove = new ArrayList<Object>();
            for (Object key : properties.keySet()) {
                if (key.toString().startsWith(prefix)) continue;
                keysToRemove.add(key);
            }
            for (Object key : keysToRemove) {
                properties.remove(key);
            }
        }
        for (Object key : properties.keySet()) {
            String name = key.toString();
            if (prefix != null) {
                name = name.substring(prefix.length());
            }
            AliasBuilder<C> alias = this.withAlias(name);
            String value = properties.getProperty(key.toString());
            if (StringUtils.isEmpty((CharSequence)value)) continue;
            List<String> args = AliasArgumentsParser.parse(value);
            alias.withArguments(args.toArray(new String[args.size()]));
        }
        return this;
    }

    public CliBuilder<C> withAliasesOverridingBuiltIns() {
        this.aliasesOverrideBuiltIns = true;
        return this;
    }

    public CliBuilder<C> withCommandAbbreviation() {
        this.allowAbbreviatedCommands = true;
        return this;
    }

    public CliBuilder<C> withOptionAbbreviation() {
        this.allowAbbreviatedOptions = true;
        return this;
    }

    @Override
    public Cli<C> build() {
        return new Cli<C>(this.name, this.description, this.typeConverter, this.defaultCommand, this.commandFactory, this.defaultCommandGroupCommands, this.groups.values(), this.aliases.values(), this.aliasesOverrideBuiltIns, this.allowAbbreviatedCommands, this.allowAbbreviatedOptions);
    }
}

