/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.builder;

import com.github.rvesse.airline.model.CommandGroupMetadata;
import com.github.rvesse.airline.model.CommandMetadata;
import com.github.rvesse.airline.model.MetadataLoader;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class GroupBuilder<C> {
    private final String name;
    private String description = null;
    private Class<? extends C> defaultCommand = null;
    private boolean hidden = false;
    private final List<Class<? extends C>> commands = Lists.newArrayList();

    GroupBuilder(String name) {
        Preconditions.checkArgument((StringUtils.isNotEmpty((CharSequence)name) && !StringUtils.isWhitespace((CharSequence)name) ? 1 : 0) != 0, (Object)"Group name cannot be null/empty/whitespace");
        this.name = name;
    }

    public GroupBuilder<C> withDescription(String description) {
        Preconditions.checkNotNull((Object)description, (Object)"description is null");
        Preconditions.checkArgument((!description.isEmpty() ? 1 : 0) != 0, (Object)"description is empty");
        Preconditions.checkState((this.description == null ? 1 : 0) != 0, (Object)"description is already set");
        this.description = description;
        return this;
    }

    public GroupBuilder<C> makeHidden() {
        return this.withHiddenState(true);
    }

    public GroupBuilder<C> makeVisible() {
        return this.withHiddenState(false);
    }

    public GroupBuilder<C> withHiddenState(boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    public GroupBuilder<C> withDefaultCommand(Class<? extends C> defaultCommand) {
        Preconditions.checkNotNull(defaultCommand, (Object)"defaultCommand is null");
        Preconditions.checkState((this.defaultCommand == null ? 1 : 0) != 0, (Object)"defaultCommand is already set");
        this.defaultCommand = defaultCommand;
        return this;
    }

    public GroupBuilder<C> withCommand(Class<? extends C> command) {
        Preconditions.checkNotNull(command, (Object)"command is null");
        this.commands.add(command);
        return this;
    }

    public GroupBuilder<C> withCommands(Class<? extends C> command, Class<? extends C> ... moreCommands) {
        this.commands.add(command);
        this.commands.addAll((Collection<Class<C>>)ImmutableList.copyOf((Object[])moreCommands));
        return this;
    }

    public GroupBuilder<C> withCommands(Iterable<Class<? extends C>> commands) {
        this.commands.addAll((Collection<Class<C>>)ImmutableList.copyOf(commands));
        return this;
    }

    public CommandGroupMetadata build() {
        CommandMetadata groupDefault = MetadataLoader.loadCommand(this.defaultCommand);
        ImmutableList<CommandMetadata> groupCommands = MetadataLoader.loadCommands(this.commands);
        return MetadataLoader.loadCommandGroup(this.name, this.description, this.hidden, groupDefault, groupCommands);
    }
}

