/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.help;

import com.github.rvesse.airline.help.AbstractUsageGenerator;
import com.github.rvesse.airline.help.CommandUsageGenerator;
import com.github.rvesse.airline.help.UsageHelper;
import com.github.rvesse.airline.model.CommandMetadata;
import com.github.rvesse.airline.model.OptionMetadata;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public abstract class AbstractCommandUsageGenerator
extends AbstractUsageGenerator
implements CommandUsageGenerator {
    private final Comparator<? super Map.Entry<Integer, String>> exitCodeComparator;

    public AbstractCommandUsageGenerator() {
        this(UsageHelper.DEFAULT_OPTION_COMPARATOR);
    }

    public AbstractCommandUsageGenerator(boolean includeHidden) {
        this((Comparator<? super OptionMetadata>)UsageHelper.DEFAULT_OPTION_COMPARATOR, (Comparator<? super Map.Entry<Integer, String>>)UsageHelper.DEFAULT_EXIT_CODE_COMPARATOR, includeHidden);
    }

    public AbstractCommandUsageGenerator(Comparator<? super OptionMetadata> optionComparator) {
        this(optionComparator, (Comparator<? super Map.Entry<Integer, String>>)UsageHelper.DEFAULT_EXIT_CODE_COMPARATOR, false);
    }

    public AbstractCommandUsageGenerator(Comparator<? super OptionMetadata> optionComparator, boolean includeHidden) {
        this(optionComparator, (Comparator<? super Map.Entry<Integer, String>>)UsageHelper.DEFAULT_EXIT_CODE_COMPARATOR, includeHidden);
    }

    public AbstractCommandUsageGenerator(Comparator<? super OptionMetadata> optionComparator, Comparator<? super Map.Entry<Integer, String>> exitCodeComparator, boolean includeHidden) {
        super(optionComparator, UsageHelper.DEFAULT_COMMAND_COMPARATOR, includeHidden);
        this.exitCodeComparator = exitCodeComparator;
    }

    @Override
    public void usage(String programName, String groupName, String commandName, CommandMetadata command) throws IOException {
        this.usage(programName, groupName, commandName, command, System.out);
    }

    protected List<Map.Entry<Integer, String>> sortExitCodes(List<Map.Entry<Integer, String>> exitCodes) {
        if (this.exitCodeComparator != null) {
            exitCodes = new ArrayList<Map.Entry<Integer, String>>(exitCodes);
            Collections.sort(exitCodes, this.exitCodeComparator);
        }
        return exitCodes;
    }
}

