/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.help;

import com.github.rvesse.airline.help.AbstractCommandUsageGenerator;
import com.github.rvesse.airline.help.UsagePrinter;
import com.github.rvesse.airline.model.CommandMetadata;
import com.github.rvesse.airline.model.OptionMetadata;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Comparator;

public abstract class AbstractPrintedCommandUsageGenerator
extends AbstractCommandUsageGenerator {
    private final int columnSize;

    public AbstractPrintedCommandUsageGenerator(int columns, Comparator<? super OptionMetadata> optionComparator, boolean includeHidden) {
        super(optionComparator, includeHidden);
        Preconditions.checkArgument((columns > 0 ? 1 : 0) != 0, (Object)"columns must be greater than 0");
        this.columnSize = columns;
    }

    protected abstract void usage(String var1, String var2, String var3, CommandMetadata var4, UsagePrinter var5) throws IOException;

    protected UsagePrinter createUsagePrinter(OutputStream out) {
        Preconditions.checkNotNull((Object)out, (Object)"OutputStream cannot be null");
        OutputStreamWriter writer = new OutputStreamWriter(out);
        return new UsagePrinter(writer, this.columnSize);
    }

    @Override
    public void usage(String programName, String groupName, String commandName, CommandMetadata command, OutputStream out) throws IOException {
        UsagePrinter printer = this.createUsagePrinter(out);
        this.usage(programName, groupName, commandName, command, printer);
        printer.flush();
    }
}

