/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.help;

import com.github.rvesse.airline.help.AbstractGlobalUsageGenerator;
import com.github.rvesse.airline.help.UsagePrinter;
import com.github.rvesse.airline.model.CommandGroupMetadata;
import com.github.rvesse.airline.model.CommandMetadata;
import com.github.rvesse.airline.model.GlobalMetadata;
import com.github.rvesse.airline.model.OptionMetadata;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Comparator;

public abstract class AbstractPrintedGlobalUsageGenerator
extends AbstractGlobalUsageGenerator {
    private final int columnSize;

    public AbstractPrintedGlobalUsageGenerator(int columnSize, Comparator<? super OptionMetadata> optionComparator, Comparator<? super CommandMetadata> commandComparator, Comparator<? super CommandGroupMetadata> commandGroupComparator, boolean includeHidden) {
        super(optionComparator, commandComparator, commandGroupComparator, includeHidden);
        Preconditions.checkArgument((columnSize > 0 ? 1 : 0) != 0, (Object)"columnSize must be greater than 0");
        this.columnSize = columnSize;
    }

    protected abstract void usage(GlobalMetadata var1, UsagePrinter var2) throws IOException;

    protected UsagePrinter createUsagePrinter(OutputStream out) {
        Preconditions.checkNotNull((Object)out, (Object)"StringBuilder cannot be null");
        return new UsagePrinter(new OutputStreamWriter(out), this.columnSize);
    }

    @Override
    public void usage(GlobalMetadata global, OutputStream out) throws IOException {
        UsagePrinter printer = this.createUsagePrinter(out);
        this.usage(global, printer);
        printer.flush();
    }
}

