/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.help;

import com.github.rvesse.airline.help.UsageHelper;
import com.github.rvesse.airline.model.ArgumentsMetadata;
import com.github.rvesse.airline.model.CommandMetadata;
import com.github.rvesse.airline.model.OptionMetadata;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;

public class AbstractUsageGenerator {
    protected static final int DEFAULT_COLUMNS = 79;
    private final Comparator<? super OptionMetadata> optionComparator;
    private final Comparator<? super CommandMetadata> commandComparator;
    private final boolean includeHidden;

    public AbstractUsageGenerator() {
        this(UsageHelper.DEFAULT_OPTION_COMPARATOR, UsageHelper.DEFAULT_COMMAND_COMPARATOR, false);
    }

    public AbstractUsageGenerator(Comparator<? super OptionMetadata> optionComparator, Comparator<? super CommandMetadata> commandComparator, boolean includeHidden) {
        this.optionComparator = optionComparator;
        this.commandComparator = commandComparator;
        this.includeHidden = includeHidden;
    }

    protected boolean includeHidden() {
        return this.includeHidden;
    }

    protected final Comparator<? super OptionMetadata> getOptionComparator() {
        return this.optionComparator;
    }

    protected final Comparator<? super CommandMetadata> getCommandComparator() {
        return this.commandComparator;
    }

    protected List<OptionMetadata> sortOptions(List<OptionMetadata> options) {
        if (this.optionComparator != null) {
            options = new ArrayList<OptionMetadata>(options);
            Collections.sort(options, this.optionComparator);
        }
        return options;
    }

    protected List<CommandMetadata> sortCommands(List<CommandMetadata> commands) {
        if (this.commandComparator != null) {
            commands = new ArrayList<CommandMetadata>(commands);
            Collections.sort(commands, this.commandComparator);
        }
        return commands;
    }

    protected final String htmlize(String value) {
        return value.replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\n", "<br/>");
    }

    protected String toDefaultCommand(String command) {
        if (Strings.isNullOrEmpty((String)command)) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[ ");
        stringBuilder.append(command);
        stringBuilder.append(" ]");
        return stringBuilder.toString();
    }

    protected List<String> toSynopsisUsage(List<OptionMetadata> options) {
        return ImmutableList.copyOf((Iterable)Iterables.transform(options, (Function)new Function<OptionMetadata, String>(){

            public String apply(OptionMetadata option) {
                if (option.isHidden() && !AbstractUsageGenerator.this.includeHidden()) {
                    return "";
                }
                return AbstractUsageGenerator.this.toUsage(option);
            }
        }));
    }

    protected String toUsage(ArgumentsMetadata arguments) {
        if (!arguments.getUsage().isEmpty()) {
            return arguments.getUsage();
        }
        boolean required = arguments.isRequired();
        StringBuilder stringBuilder = new StringBuilder();
        if (!required) {
            stringBuilder.append("[ ");
        }
        stringBuilder.append(this.toDescription(arguments));
        if (arguments.isMultiValued()) {
            stringBuilder.append("...");
        }
        if (!required) {
            stringBuilder.append(" ]");
        }
        return stringBuilder.toString();
    }

    protected String toUsage(OptionMetadata option) {
        Set<String> options = option.getOptions();
        boolean required = option.isRequired();
        StringBuilder stringBuilder = new StringBuilder();
        if (!required) {
            stringBuilder.append("[ ");
        }
        if (options.size() > 1) {
            stringBuilder.append('{');
        }
        String argumentString = option.getArity() > 0 ? Joiner.on((String)" ").join(Iterables.transform((Iterable)ImmutableList.of((Object)option.getTitle()), (Function)new Function<String, String>(){

            public String apply(String argument) {
                return "<" + argument + ">";
            }
        })) : null;
        Joiner.on((String)" | ").appendTo(stringBuilder, Iterables.transform(options, (Function)new Function<String, String>(){

            public String apply(String option) {
                return option;
            }
        }));
        if (options.size() > 1) {
            stringBuilder.append('}');
        }
        if (argumentString != null) {
            stringBuilder.append(" " + argumentString);
        }
        if (option.isMultiValued()) {
            stringBuilder.append("...");
        }
        if (!required) {
            stringBuilder.append(" ]");
        }
        return stringBuilder.toString();
    }

    protected String toDescription(ArgumentsMetadata arguments) {
        if (!arguments.getUsage().isEmpty()) {
            return arguments.getUsage();
        }
        List<String> descriptionTitles = arguments.getTitle();
        StringBuilder stringBuilder = new StringBuilder();
        for (String title : descriptionTitles) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" ");
            }
            stringBuilder.append("<");
            stringBuilder.append(title);
            stringBuilder.append(">");
        }
        return stringBuilder.toString();
    }

    protected String toDescription(OptionMetadata option) {
        Set<String> options = option.getOptions();
        StringBuilder stringBuilder = new StringBuilder();
        final String argumentString = option.getArity() > 0 ? Joiner.on((String)" ").join((Iterable)Lists.transform((List)ImmutableList.of((Object)option.getTitle()), (Function)new Function<String, String>(){

            public String apply(String argument) {
                return "<" + argument + ">";
            }
        })) : null;
        Joiner.on((String)", ").appendTo(stringBuilder, Iterables.transform(options, (Function)new Function<String, String>(){

            public String apply(String option) {
                if (argumentString != null) {
                    return option + " " + argumentString;
                }
                return option;
            }
        }));
        return stringBuilder.toString();
    }
}

