/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.help;

import com.github.rvesse.airline.Arguments;
import com.github.rvesse.airline.Command;
import com.github.rvesse.airline.Option;
import com.github.rvesse.airline.help.cli.CliCommandGroupUsageGenerator;
import com.github.rvesse.airline.help.cli.CliCommandUsageGenerator;
import com.github.rvesse.airline.help.cli.CliGlobalUsageGenerator;
import com.github.rvesse.airline.help.cli.CliGlobalUsageSummaryGenerator;
import com.github.rvesse.airline.model.CommandGroupMetadata;
import com.github.rvesse.airline.model.CommandMetadata;
import com.github.rvesse.airline.model.GlobalMetadata;
import com.github.rvesse.airline.parser.AbbreviatedCommandFinder;
import com.github.rvesse.airline.parser.AbbreviatedGroupFinder;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import javax.inject.Inject;

@Command(name="help", description="Display help information")
public class Help
implements Runnable,
Callable<Void> {
    @Inject
    public GlobalMetadata global;
    @Arguments
    public List<String> command = Lists.newArrayList();
    @Option(name={"--include-hidden"}, description="When set the help output will include hidden commands and options", hidden=true)
    public boolean includeHidden = false;

    @Override
    public void run() {
        try {
            Help.help(this.global, this.command, this.includeHidden);
        }
        catch (IOException e) {
            throw new RuntimeException("Error generating usage documentation", e);
        }
    }

    @Override
    public Void call() {
        this.run();
        return null;
    }

    public static void help(CommandMetadata command) throws IOException {
        Help.help(command, System.out);
    }

    public static void help(CommandMetadata command, boolean includeHidden) throws IOException {
        Help.help(command, includeHidden, (OutputStream)System.out);
    }

    public static void help(CommandMetadata command, OutputStream out) throws IOException {
        Help.help(command, false, out);
    }

    public static void help(CommandMetadata command, boolean includeHidden, OutputStream out) throws IOException {
        new CliCommandUsageGenerator(includeHidden).usage(null, null, command.getName(), command, out);
    }

    public static void help(GlobalMetadata global, List<String> commandNames) throws IOException {
        Help.help(global, commandNames, false, System.out);
    }

    public static void help(GlobalMetadata global, List<String> commandNames, boolean includeHidden) throws IOException {
        Help.help(global, commandNames, includeHidden, System.out);
    }

    public static void help(GlobalMetadata global, List<String> commandNames, OutputStream out) throws IOException {
        Help.help(global, commandNames, false, out);
    }

    public static void help(GlobalMetadata global, List<String> commandNames, boolean includeHidden, OutputStream out) throws IOException {
        if (commandNames.isEmpty()) {
            new CliGlobalUsageSummaryGenerator(includeHidden).usage(global, out);
            return;
        }
        String name = commandNames.get(0);
        if (name.equals(global.getName())) {
            new CliGlobalUsageGenerator(includeHidden).usage(global, out);
            return;
        }
        AbbreviatedGroupFinder findGroupPredicate = global.allowsAbbreviatedCommands() ? new AbbreviatedGroupFinder(name, (Collection<CommandGroupMetadata>)global.getCommandGroups()) : Predicates.compose((Predicate)Predicates.equalTo((Object)name), CommandGroupMetadata.nameGetter());
        AbbreviatedCommandFinder findCommandPredicate = global.allowsAbbreviatedCommands() ? new AbbreviatedCommandFinder(name, (Collection<CommandMetadata>)global.getDefaultGroupCommands()) : Predicates.compose((Predicate)Predicates.equalTo((Object)name), CommandMetadata.nameGetter());
        CommandMetadata command = (CommandMetadata)Iterables.find(global.getDefaultGroupCommands(), (Predicate)findCommandPredicate, null);
        if (command != null) {
            new CliCommandUsageGenerator(includeHidden).usage(global.getName(), null, command.getName(), command, out);
            return;
        }
        CommandGroupMetadata group = (CommandGroupMetadata)Iterables.find(global.getCommandGroups(), (Predicate)findGroupPredicate, null);
        if (group != null) {
            if (commandNames.size() == 1) {
                new CliCommandGroupUsageGenerator(includeHidden).usage(global, group, out);
                return;
            }
            String commandName = commandNames.get(1);
            findCommandPredicate = global.allowsAbbreviatedCommands() ? new AbbreviatedCommandFinder(commandName, (Collection<CommandMetadata>)group.getCommands()) : Predicates.compose((Predicate)Predicates.equalTo((Object)commandName), CommandMetadata.nameGetter());
            command = (CommandMetadata)Iterables.find(group.getCommands(), (Predicate)findCommandPredicate, null);
            if (command != null) {
                new CliCommandUsageGenerator().usage(global.getName(), group.getName(), command.getName(), command, out);
                return;
            }
            if (global.allowsAbbreviatedCommands()) {
                System.out.println("Unknown command " + name + " " + commandName + " or an ambiguous abbreviation");
            } else {
                System.out.println("Unknown command " + name + " " + commandName);
            }
        }
        if (global.allowsAbbreviatedCommands()) {
            System.out.println("Unknown command " + name + " or an ambiguous abbreviation");
        } else {
            System.out.println("Unknown command " + name);
        }
    }
}

