/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.help;

import com.github.rvesse.airline.Arguments;
import com.github.rvesse.airline.Command;
import com.github.rvesse.airline.Context;
import com.github.rvesse.airline.help.CommandSuggester;
import com.github.rvesse.airline.help.GlobalSuggester;
import com.github.rvesse.airline.help.GroupSuggester;
import com.github.rvesse.airline.help.Suggester;
import com.github.rvesse.airline.model.CommandGroupMetadata;
import com.github.rvesse.airline.model.CommandMetadata;
import com.github.rvesse.airline.model.GlobalMetadata;
import com.github.rvesse.airline.model.MetadataLoader;
import com.github.rvesse.airline.model.OptionMetadata;
import com.github.rvesse.airline.model.SuggesterMetadata;
import com.github.rvesse.airline.parser.ParseState;
import com.github.rvesse.airline.parser.Parser;
import com.github.rvesse.airline.parser.ParserUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.inject.Inject;

@Command(name="suggest")
public class SuggestCommand
implements Runnable,
Callable<Void> {
    private static final Map<Context, Class<? extends Suggester>> BUILTIN_SUGGESTERS = ImmutableMap.builder().put((Object)Context.GLOBAL, GlobalSuggester.class).put((Object)Context.GROUP, GroupSuggester.class).put((Object)Context.COMMAND, CommandSuggester.class).build();
    @Inject
    public GlobalMetadata metadata;
    @Arguments
    public List<String> arguments = Lists.newArrayList();

    @VisibleForTesting
    public Iterable<String> generateSuggestions() {
        SuggesterMetadata suggesterMetadata;
        Parser parser = new Parser();
        ParseState state = parser.parse(this.metadata, this.arguments);
        Class<? extends Suggester> suggesterClass = BUILTIN_SUGGESTERS.get((Object)state.getLocation());
        if (suggesterClass != null && (suggesterMetadata = MetadataLoader.loadSuggester(suggesterClass)) != null) {
            ImmutableMap.Builder bindings = ImmutableMap.builder().put(GlobalMetadata.class, (Object)this.metadata);
            if (state.getGroup() != null) {
                bindings.put(CommandGroupMetadata.class, (Object)state.getGroup());
            }
            if (state.getCommand() != null) {
                bindings.put(CommandMetadata.class, (Object)state.getCommand());
            }
            Suggester suggester = (Suggester)ParserUtil.createInstance(suggesterMetadata.getSuggesterClass(), (Iterable<OptionMetadata>)ImmutableList.of(), null, null, null, suggesterMetadata.getMetadataInjections(), bindings.build());
            return suggester.suggest();
        }
        return ImmutableList.of();
    }

    @Override
    public void run() {
        System.out.println(Joiner.on((String)"\n").join(this.generateSuggestions()));
    }

    @Override
    public Void call() {
        this.run();
        return null;
    }
}

