/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.help;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;

public class UsagePrinter {
    private final Writer out;
    private final int maxSize;
    private final int indent;
    private final int hangingIndent;
    private final AtomicInteger currentPosition;

    public UsagePrinter(Writer out) {
        this(out, 79);
    }

    public UsagePrinter(Writer out, int maxSize) {
        this(out, maxSize, 0, 0, new AtomicInteger());
    }

    public UsagePrinter(Writer out, int maxSize, int indent, int hangingIndent, AtomicInteger currentPosition) {
        Preconditions.checkNotNull((Object)out, (Object)"Writer cannot be null");
        this.out = out;
        this.maxSize = maxSize;
        this.indent = indent;
        this.hangingIndent = hangingIndent;
        this.currentPosition = currentPosition;
    }

    public UsagePrinter newIndentedPrinter(int size) {
        return new UsagePrinter(this.out, this.maxSize, this.indent + size, this.hangingIndent, this.currentPosition);
    }

    public UsagePrinter newPrinterWithHangingIndent(int size) {
        return new UsagePrinter(this.out, this.maxSize, this.indent, this.hangingIndent + size, this.currentPosition);
    }

    public UsagePrinter newline() throws IOException {
        this.out.append("\n");
        this.currentPosition.set(0);
        return this;
    }

    public UsagePrinter appendTable(Iterable<? extends Iterable<String>> table, int rowSpacing) throws IOException {
        int column;
        ArrayList columnSizes = Lists.newArrayList();
        for (Iterable<String> iterable : table) {
            column = 0;
            for (String value : iterable) {
                while (column >= columnSizes.size()) {
                    columnSizes.add(0);
                }
                columnSizes.set(column, Math.max(value.length(), (Integer)columnSizes.get(column)));
                ++column;
            }
        }
        if (this.currentPosition.get() != 0) {
            this.currentPosition.set(0);
            this.out.append("\n");
        }
        for (Iterable<String> iterable : table) {
            column = 0;
            StringBuilder line = new StringBuilder();
            for (String value : iterable) {
                int columnSize = (Integer)columnSizes.get(column);
                line.append(value);
                line.append(UsagePrinter.spaces(columnSize - value.length()));
                line.append("   ");
                ++column;
            }
            this.out.append(UsagePrinter.spaces(this.indent)).append(UsagePrinter.trimEnd(line.toString())).append("\n");
            for (int i = 0; i < rowSpacing; ++i) {
                this.out.append('\n');
            }
        }
        return this;
    }

    public static String trimEnd(String str) {
        int end;
        if (Strings.isNullOrEmpty((String)str)) {
            return str;
        }
        for (end = str.length(); end != 0 && Character.isWhitespace(str.charAt(end - 1)); --end) {
        }
        return str.substring(0, end);
    }

    public UsagePrinter append(String value) throws IOException {
        return this.append(value, false);
    }

    public UsagePrinter appendOnOneLine(String value) throws IOException {
        return this.append(value, true);
    }

    public UsagePrinter appendWords(Iterable<String> words) throws IOException {
        return this.appendWords(words, false);
    }

    public UsagePrinter append(String value, boolean avoidNewlines) throws IOException {
        if (value == null) {
            return this;
        }
        if (avoidNewlines) {
            return this.appendWords(Splitter.onPattern((String)"\\s+").trimResults().split((CharSequence)value), avoidNewlines);
        }
        return this.appendLines(Splitter.on((char)'\n').split((CharSequence)value), avoidNewlines);
    }

    public UsagePrinter appendLines(Iterable<String> lines) throws IOException {
        return this.appendLines(lines, false);
    }

    public UsagePrinter appendLines(Iterable<String> lines, boolean avoidNewlines) throws IOException {
        Iterator<String> iter = lines.iterator();
        while (iter.hasNext()) {
            String line = iter.next();
            if (line == null || line.isEmpty()) continue;
            this.appendWords(Splitter.onPattern((String)"\\s+").trimResults().split((CharSequence)String.valueOf(line)), avoidNewlines);
            if (!iter.hasNext()) continue;
            this.newline();
        }
        return this;
    }

    public UsagePrinter appendWords(Iterable<String> words, boolean avoidNewlines) throws IOException {
        int bracketCount = 0;
        for (String word : words) {
            if (null == word || "".equals(word)) continue;
            if (this.currentPosition.get() == 0) {
                this.out.append(UsagePrinter.spaces(this.indent));
                this.currentPosition.getAndAdd(this.indent);
            } else if (word.length() > this.maxSize || this.currentPosition.get() + word.length() <= this.maxSize || bracketCount > 0 || avoidNewlines) {
                this.out.append(" ");
                this.currentPosition.getAndIncrement();
            } else {
                this.out.append("\n").append(UsagePrinter.spaces(this.indent)).append(UsagePrinter.spaces(this.hangingIndent));
                this.currentPosition.set(this.indent);
            }
            this.out.append(word);
            this.currentPosition.getAndAdd(word.length());
            if (word.contains("{") || word.contains("[") || word.contains("<")) {
                ++bracketCount;
            }
            if (!word.contains("}") && !word.contains("]") && !word.contains(">")) continue;
            --bracketCount;
        }
        return this;
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void close() throws IOException {
        this.out.close();
    }

    private static String spaces(int count) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            result.append(" ");
        }
        return result.toString();
    }
}

