/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.help.cli;

import com.github.rvesse.airline.help.AbstractPrintedGlobalUsageGenerator;
import com.github.rvesse.airline.help.UsageHelper;
import com.github.rvesse.airline.help.UsagePrinter;
import com.github.rvesse.airline.model.CommandGroupMetadata;
import com.github.rvesse.airline.model.CommandMetadata;
import com.github.rvesse.airline.model.GlobalMetadata;
import com.github.rvesse.airline.model.OptionMetadata;
import java.io.IOException;
import java.util.Comparator;
import java.util.List;

public class CliGlobalUsageGenerator
extends AbstractPrintedGlobalUsageGenerator {
    public CliGlobalUsageGenerator() {
        this(79, UsageHelper.DEFAULT_OPTION_COMPARATOR, UsageHelper.DEFAULT_COMMAND_COMPARATOR, UsageHelper.DEFAULT_COMMAND_GROUP_COMPARATOR, false);
    }

    public CliGlobalUsageGenerator(boolean includeHidden) {
        this(79, UsageHelper.DEFAULT_OPTION_COMPARATOR, UsageHelper.DEFAULT_COMMAND_COMPARATOR, UsageHelper.DEFAULT_COMMAND_GROUP_COMPARATOR, includeHidden);
    }

    public CliGlobalUsageGenerator(int columns) {
        this(columns, UsageHelper.DEFAULT_OPTION_COMPARATOR, UsageHelper.DEFAULT_COMMAND_COMPARATOR, UsageHelper.DEFAULT_COMMAND_GROUP_COMPARATOR, false);
    }

    public CliGlobalUsageGenerator(int columns, boolean includeHidden) {
        this(columns, UsageHelper.DEFAULT_OPTION_COMPARATOR, UsageHelper.DEFAULT_COMMAND_COMPARATOR, UsageHelper.DEFAULT_COMMAND_GROUP_COMPARATOR, includeHidden);
    }

    public CliGlobalUsageGenerator(int columnSize, Comparator<? super OptionMetadata> optionComparator, Comparator<? super CommandMetadata> commandComparator, Comparator<? super CommandGroupMetadata> commandGroupComparator, boolean includeHidden) {
        super(columnSize, optionComparator, commandComparator, commandGroupComparator, includeHidden);
    }

    @Override
    protected void usage(GlobalMetadata global, UsagePrinter out) throws IOException {
        this.outputDescription(out, global);
        this.outputSynopsis(out, global);
        List<OptionMetadata> options = this.sortOptions(global.getOptions());
        if (options.size() > 0) {
            this.outputOptions(out, options);
        }
        this.outputCommandList(out, global);
    }

    protected void outputCommandList(UsagePrinter out, GlobalMetadata global) throws IOException {
        out.append("COMMANDS").newline();
        UsagePrinter commandPrinter = out.newIndentedPrinter(8);
        for (CommandMetadata command : this.sortCommands(global.getDefaultGroupCommands())) {
            this.outputCommandDescription(commandPrinter, null, command);
        }
        for (CommandGroupMetadata group : this.sortCommandGroups(global.getCommandGroups())) {
            if (group.isHidden() && !this.includeHidden()) continue;
            for (CommandMetadata command : this.sortCommands(group.getCommands())) {
                this.outputCommandDescription(commandPrinter, group, command);
            }
        }
    }

    protected void outputOptions(UsagePrinter out, List<OptionMetadata> options) throws IOException {
        out.append("OPTIONS").newline();
        for (OptionMetadata option : options) {
            if (option.isHidden() && !this.includeHidden()) continue;
            UsagePrinter optionPrinter = out.newIndentedPrinter(8);
            optionPrinter.append(this.toDescription(option)).newline();
            UsagePrinter descriptionPrinter = optionPrinter.newIndentedPrinter(4);
            descriptionPrinter.append(option.getDescription()).newline();
            if (option.getAllowedValues() != null && option.getAllowedValues().size() > 0 && option.getArity() >= 1) {
                this.outputAllowedValues(descriptionPrinter, option);
            }
            descriptionPrinter.newline();
        }
    }

    protected void outputAllowedValues(UsagePrinter out, OptionMetadata option) throws IOException {
        out.newline();
        out.append("This options value");
        if (option.getArity() == 1) {
            out.append(" is ");
        } else {
            out.append("s are ");
        }
        out.append("restricted to the following value(s):").newline();
        UsagePrinter allowedValuesPrinter = out.newIndentedPrinter(4);
        for (String value : option.getAllowedValues()) {
            allowedValuesPrinter.append(value).newline();
        }
        allowedValuesPrinter.flush();
    }

    protected void outputSynopsis(UsagePrinter out, GlobalMetadata global) throws IOException {
        out.append("SYNOPSIS").newline();
        out.newIndentedPrinter(8).newPrinterWithHangingIndent(8).append(global.getName()).appendWords(this.toSynopsisUsage(global.getOptions())).append("<command> [ <args> ]").newline().newline();
    }

    protected void outputDescription(UsagePrinter out, GlobalMetadata global) throws IOException {
        out.append("NAME").newline();
        out.newIndentedPrinter(8).append(global.getName()).append("-").append(global.getDescription()).newline().newline();
    }

    protected void outputCommandDescription(UsagePrinter out, CommandGroupMetadata group, CommandMetadata command) throws IOException {
        if (!command.isHidden() || this.includeHidden()) {
            if (group != null) {
                out.append(group.getName());
            }
            out.append(command.getName()).newline();
            if (command.getDescription() != null) {
                out.newIndentedPrinter(4).append(command.getDescription()).newline();
            }
            out.newline();
        }
    }
}

