/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.help.cli;

import com.github.rvesse.airline.help.AbstractPrintedGlobalUsageGenerator;
import com.github.rvesse.airline.help.UsageHelper;
import com.github.rvesse.airline.help.UsagePrinter;
import com.github.rvesse.airline.model.CommandGroupMetadata;
import com.github.rvesse.airline.model.CommandMetadata;
import com.github.rvesse.airline.model.GlobalMetadata;
import com.github.rvesse.airline.model.OptionMetadata;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;

public class CliGlobalUsageSummaryGenerator
extends AbstractPrintedGlobalUsageGenerator {
    public CliGlobalUsageSummaryGenerator() {
        this(79, UsageHelper.DEFAULT_OPTION_COMPARATOR, UsageHelper.DEFAULT_COMMAND_COMPARATOR, UsageHelper.DEFAULT_COMMAND_GROUP_COMPARATOR, false);
    }

    public CliGlobalUsageSummaryGenerator(boolean includeHidden) {
        this(79, UsageHelper.DEFAULT_OPTION_COMPARATOR, UsageHelper.DEFAULT_COMMAND_COMPARATOR, UsageHelper.DEFAULT_COMMAND_GROUP_COMPARATOR, includeHidden);
    }

    public CliGlobalUsageSummaryGenerator(int columnSize) {
        this(columnSize, UsageHelper.DEFAULT_OPTION_COMPARATOR, UsageHelper.DEFAULT_COMMAND_COMPARATOR, UsageHelper.DEFAULT_COMMAND_GROUP_COMPARATOR, false);
    }

    public CliGlobalUsageSummaryGenerator(int columnSize, boolean includeHidden) {
        this(columnSize, UsageHelper.DEFAULT_OPTION_COMPARATOR, UsageHelper.DEFAULT_COMMAND_COMPARATOR, UsageHelper.DEFAULT_COMMAND_GROUP_COMPARATOR, includeHidden);
    }

    public CliGlobalUsageSummaryGenerator(int columnSize, Comparator<? super OptionMetadata> optionComparator, Comparator<? super CommandMetadata> commandComparator, Comparator<? super CommandGroupMetadata> commandGroupComparator, boolean includeHidden) {
        super(columnSize, optionComparator, commandComparator, commandGroupComparator, includeHidden);
    }

    @Override
    public void usage(GlobalMetadata global, UsagePrinter out) throws IOException {
        this.outputSynopsis(out, global);
        this.outputCommandList(out, global);
        this.outputFooter(out, global);
    }

    protected void outputFooter(UsagePrinter out, GlobalMetadata global) throws IOException {
        out.newline();
        out.append("See").append("'" + global.getName()).append("help <command>' for more information on a specific command.").newline();
    }

    protected void outputCommandList(UsagePrinter out, GlobalMetadata global) throws IOException {
        LinkedHashMap<String, String> commands = new LinkedHashMap<String, String>();
        for (CommandMetadata commandMetadata : this.sortCommands(global.getDefaultGroupCommands())) {
            if (commandMetadata.isHidden() && !this.includeHidden()) continue;
            commands.put(commandMetadata.getName(), commandMetadata.getDescription());
        }
        for (CommandGroupMetadata group : this.sortCommandGroups(global.getCommandGroups())) {
            if (group.isHidden() && !this.includeHidden()) continue;
            commands.put(group.getName(), group.getDescription());
        }
        out.append("Commands are:").newline();
        out.newIndentedPrinter(4).appendTable(Iterables.transform(commands.entrySet(), (Function)new Function<Map.Entry<String, String>, Iterable<String>>(){

            public Iterable<String> apply(Map.Entry<String, String> entry) {
                return ImmutableList.of((Object)entry.getKey(), (Object)(entry.getValue() != null ? entry.getValue() : ""));
            }
        }), 0);
    }

    protected void outputSynopsis(UsagePrinter out, GlobalMetadata global) throws IOException {
        ArrayList commandArguments = Lists.newArrayList();
        Collection args = Collections2.transform(this.sortOptions(global.getOptions()), (Function)new Function<OptionMetadata, String>(){

            public String apply(OptionMetadata option) {
                if (option.isHidden() && !CliGlobalUsageSummaryGenerator.this.includeHidden()) {
                    return "";
                }
                return CliGlobalUsageSummaryGenerator.this.toUsage(option);
            }
        });
        commandArguments.addAll(args);
        out.newPrinterWithHangingIndent(8).append("usage:").append(global.getName()).appendWords(commandArguments).append("<command> [ <args> ]").newline().newline();
    }
}

