/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.help.html;

import com.github.rvesse.airline.help.AbstractCommandUsageGenerator;
import com.github.rvesse.airline.help.UsageHelper;
import com.github.rvesse.airline.model.ArgumentsMetadata;
import com.github.rvesse.airline.model.CommandMetadata;
import com.github.rvesse.airline.model.OptionMetadata;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class HtmlCommandUsageGenerator
extends AbstractCommandUsageGenerator {
    public static final String DEFAULT_STYLESHEET = "css/bootstrap.min.css";
    protected static final String NEWLINE = "<br/>\n";
    protected final List<String> stylesheetUrls = Lists.newArrayList();

    public HtmlCommandUsageGenerator() {
        this(UsageHelper.DEFAULT_OPTION_COMPARATOR, false, DEFAULT_STYLESHEET);
    }

    public HtmlCommandUsageGenerator(boolean includeHidden) {
        this(UsageHelper.DEFAULT_OPTION_COMPARATOR, includeHidden, DEFAULT_STYLESHEET);
    }

    public HtmlCommandUsageGenerator(String stylesheetUrl, boolean includeHidden) {
        this(UsageHelper.DEFAULT_OPTION_COMPARATOR, includeHidden, stylesheetUrl);
    }

    public HtmlCommandUsageGenerator(Comparator<? super OptionMetadata> optionComparator, boolean includeHidden, String ... stylesheetUrls) {
        super(optionComparator, includeHidden);
        if (stylesheetUrls != null) {
            for (String stylesheet : stylesheetUrls) {
                if (!StringUtils.isNotEmpty((CharSequence)stylesheet)) continue;
                this.stylesheetUrls.add(stylesheet);
            }
        }
    }

    @Override
    public void usage(String programName, String groupName, String commandName, CommandMetadata command, OutputStream output) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(output);
        this.outputHtmlHeader(writer);
        ((Writer)writer).append("<body>\n");
        this.outputPageHeader(writer, programName, groupName, command);
        this.outputDescription(writer, programName, groupName, command);
        List<OptionMetadata> options = this.outputSynopsis(writer, programName, groupName, command);
        if (options.size() > 0 || command.getArguments() != null) {
            options = this.sortOptions(options);
            this.outputOptions(writer, options, command.getArguments());
        }
        if (command.getDiscussion() != null && !command.getDiscussion().isEmpty()) {
            this.outputDiscussion(writer, command);
        }
        if (command.getExamples() != null && !command.getExamples().isEmpty()) {
            this.outputExamples(writer, command);
        }
        if (command.getExitCodes() != null && !command.getExitCodes().isEmpty()) {
            this.outputExitCodes(writer, programName, groupName, commandName, command);
        }
        ((Writer)writer).append("</body>\n");
        ((Writer)writer).append("</html>\n");
        ((Writer)writer).flush();
        output.flush();
    }

    protected void outputExitCodes(Writer writer, String programName, String groupName, String commandName, CommandMetadata command) throws IOException {
        writer.append(NEWLINE);
        writer.append("<h1 class=\"text-info\">EXIT STATUS</h1>\n").append(NEWLINE);
        writer.append("<p>\n");
        writer.append("  The ");
        if (programName != null) {
            writer.append(programName).append(" ");
        }
        if (groupName != null) {
            writer.append(groupName).append(" ");
        }
        writer.append(commandName).append(" command exits with one of the following values:");
        writer.append("</p>\n");
        for (Map.Entry<Integer, String> exit : this.sortExitCodes(Lists.newArrayList(command.getExitCodes().entrySet()))) {
            writer.append("<div class=\"row\">\n");
            writer.append("<div class=\"span8 offset1\">\n");
            writer.append(exit.getKey().toString());
            if (!StringUtils.isEmpty((CharSequence)exit.getValue())) {
                writer.append("</div>\n");
                writer.append("</div>\n");
                writer.append("<div class=\"row\">\n");
                writer.append("<div class=\"span8 offset2\">\n");
                writer.append(this.htmlize(exit.getValue()));
                writer.append("</div>\n");
                writer.append("</div>\n");
                continue;
            }
            writer.append("</div>\n");
            writer.append("</div>\n");
        }
    }

    protected void outputExamples(Writer writer, CommandMetadata command) throws IOException {
        writer.append(NEWLINE);
        writer.append("<h1 class=\"text-info\">EXAMPLES</h1>\n").append(NEWLINE);
        writer.append("<div class=\"row\">\n");
        writer.append("<div class=\"span12 offset1\">\n");
        for (String example : command.getExamples()) {
            writer.append("<p>\n");
            writer.append(example);
            writer.append("</p>\n");
        }
        writer.append("</div>\n");
        writer.append("</div>\n");
    }

    protected void outputDiscussion(Writer writer, CommandMetadata command) throws IOException {
        if (command.getDiscussion() == null || command.getDiscussion().isEmpty()) {
            return;
        }
        writer.append(NEWLINE);
        writer.append("<h1 class=\"text-info\">DISCUSSION</h1>\n").append(NEWLINE);
        writer.append("<div class=\"row\">\n");
        writer.append("<div class=\"span8 offset1\">\n");
        for (String discussionPara : command.getDiscussion()) {
            if (StringUtils.isEmpty((CharSequence)discussionPara)) continue;
            writer.append("<p>\n");
            writer.append(this.htmlize(discussionPara));
            writer.append("</p>\n");
        }
        writer.append("</div>\n");
        writer.append("</div>\n");
    }

    protected void outputOptions(Writer writer, List<OptionMetadata> options, ArgumentsMetadata arguments) throws IOException {
        writer.append(NEWLINE);
        writer.append("<h1 class=\"text-info\">OPTIONS</h1>\n").append(NEWLINE);
        for (OptionMetadata option : options) {
            if (option.isHidden() && !this.includeHidden()) continue;
            writer.append("<div class=\"row\">\n");
            writer.append("<div class=\"span8 offset1\">\n");
            writer.append(this.htmlize(this.toDescription(option)));
            writer.append("</div>\n");
            writer.append("</div>\n");
            writer.append("<div class=\"row\">\n");
            writer.append("<div class=\"span8 offset2\">\n");
            writer.append(this.htmlize(option.getDescription()));
            writer.append("</div>\n");
            writer.append("</div>\n");
            if (option.getAllowedValues() == null || option.getAllowedValues().size() <= 0 || option.getArity() < 1) continue;
            this.outputAllowedValues(writer, option);
        }
        if (arguments != null) {
            writer.append("<div class=\"row\">\n");
            writer.append("<div class=\"span8 offset1\">\n");
            writer.append("--\n");
            writer.append("</div>\n");
            writer.append("</div>\n");
            writer.append("<div class=\"row\">\n");
            writer.append("<div class=\"span8 offset2\">\n");
            writer.append("This option can be used to separate command-line options from the list of argument, (useful when arguments might be mistaken for command-line options)\n");
            writer.append("</div>\n");
            writer.append("</div>\n");
            writer.append("<div class=\"row\">\n");
            writer.append("<div class=\"span8 offset1\">\n");
            writer.append(this.htmlize(this.toDescription(arguments)));
            writer.append("</div>\n");
            writer.append("</div>\n");
            writer.append("<div class=\"row\">\n");
            writer.append("<div class=\"span8 offset2\">\n");
            writer.append(this.htmlize(arguments.getDescription()));
            writer.append("</div>\n");
            writer.append("</div>\n");
        }
    }

    protected void outputAllowedValues(Writer writer, OptionMetadata option) throws IOException {
        writer.append("<div class=\"row\">\n");
        writer.append("<div class=\"span8 offset3\">\n");
        writer.append("This options value");
        if (option.getArity() == 1) {
            writer.append(" is ");
        } else {
            writer.append("s are ");
        }
        writer.append("restricted to the following value(s):\n");
        writer.append("<ul>");
        for (String value : option.getAllowedValues()) {
            writer.append("<li>").append(value).append("</li>\n");
        }
        writer.append("</ul>");
        writer.append("</div>\n");
        writer.append("</div>\n");
    }

    protected List<OptionMetadata> outputSynopsis(Writer writer, String programName, String groupName, CommandMetadata command) throws IOException {
        writer.append("<h1 class=\"text-info\">SYNOPSIS</h1>\n").append(NEWLINE);
        ArrayList options = Lists.newArrayList();
        writer.append("<div class=\"row\">\n");
        writer.append("<div class=\"span8 offset1\">\n");
        if (programName != null) {
            writer.append(programName).append(" ").append(this.htmlize(Joiner.on((String)" ").join(this.toSynopsisUsage(this.sortOptions(command.getGlobalOptions())))));
            options.addAll(command.getGlobalOptions());
        }
        if (groupName != null) {
            writer.append(groupName).append(" ").append(this.htmlize(Joiner.on((String)" ").join(this.toSynopsisUsage(this.sortOptions(command.getGroupOptions())))));
            options.addAll(command.getGroupOptions());
        }
        writer.append(command.getName()).append(" ").append(this.htmlize(Joiner.on((String)" ").join(this.toSynopsisUsage(this.sortOptions(command.getCommandOptions())))));
        options.addAll(command.getCommandOptions());
        ArgumentsMetadata arguments = command.getArguments();
        if (arguments != null) {
            writer.append(" [--] ").append(this.htmlize(this.toUsage(arguments)));
        }
        writer.append("</div>\n");
        writer.append("</div>\n");
        return options;
    }

    protected void outputDescription(Writer writer, String programName, String groupName, CommandMetadata command) throws IOException {
        writer.append("<h2 class=\"text-info\">NAME</h1>\n").append(NEWLINE);
        writer.append("<div class=\"row\">");
        writer.append("<div class=\"span8 offset1\">");
        writer.append(programName).append(" ");
        writer.append(groupName).append(" ");
        writer.append(command.getName()).append(" ");
        writer.append("&mdash;");
        writer.append(this.htmlize(command.getDescription()));
        writer.append("</div>\n");
        writer.append("</div>\n");
        writer.append(NEWLINE);
    }

    protected void outputPageHeader(Writer writer, String programName, String groupName, CommandMetadata command) throws IOException {
        writer.append("<hr/>\n");
        writer.append("<h1 class=\"text-info\">").append(programName).append(" ").append(groupName).append(" ").append(command.getName()).append(" Manual Page\n");
        writer.append("<hr/>\n");
    }

    protected void outputHtmlHeader(Writer writer) throws IOException {
        writer.append("<html>\n");
        writer.append("<head>\n");
        this.outputStylesheets(writer);
        writer.append("<style>\n");
        this.outputAdditionalCss(writer);
        writer.append("</style>\n");
        writer.append("</head>\n");
    }

    protected void outputAdditionalCss(Writer writer) throws IOException {
        writer.append("    body { margin: 50px; }\n");
    }

    protected void outputStylesheets(Writer writer) throws IOException {
        for (String stylesheet : this.stylesheetUrls) {
            writer.append("<link href=\"").append(stylesheet).append("\" rel=\"stylesheet\">\n");
        }
    }
}

