/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.help.ronn;

import com.github.rvesse.airline.help.AbstractCommandUsageGenerator;
import com.github.rvesse.airline.model.CommandMetadata;
import com.github.rvesse.airline.model.OptionMetadata;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class RonnCommandUsageGenerator
extends AbstractCommandUsageGenerator {
    private final int manSection;
    private final boolean standalone;
    protected static final String NEW_PARA = "\n\n";
    protected static final String HORIZONTAL_RULE = "---";

    public RonnCommandUsageGenerator() {
        this(1, false, true);
    }

    public RonnCommandUsageGenerator(int manSection, boolean includeHidden, boolean standalone) {
        super(includeHidden);
        this.manSection = manSection;
        this.standalone = standalone;
    }

    @Override
    public void usage(String programName, String groupName, String commandName, CommandMetadata command, OutputStream output) throws IOException {
        OutputStreamWriter writer;
        List<OptionMetadata> options;
        String SECTION_HEADER = "## ";
        if (commandName == null) {
            commandName = command.getName();
        }
        if ((options = this.outputSynopsis(writer = new OutputStreamWriter(output), programName, groupName, commandName, command, SECTION_HEADER = this.outputTitle(writer, programName, groupName, commandName, command, SECTION_HEADER))).size() > 0 || command.getArguments() != null) {
            this.outputOptions(writer, command, options, SECTION_HEADER);
        }
        if (command.getDiscussion() != null && !command.getDiscussion().isEmpty()) {
            this.outputDiscussion(writer, command, SECTION_HEADER);
        }
        if (command.getExamples() != null && !command.getExamples().isEmpty()) {
            this.outputExamples(writer, command, SECTION_HEADER);
        }
        if (command.getExitCodes() != null && !command.getExitCodes().isEmpty()) {
            this.outputExitCodes(writer, programName, groupName, commandName, command, SECTION_HEADER);
        }
        ((Writer)writer).flush();
        output.flush();
    }

    protected void outputOptions(Writer writer, CommandMetadata command, List<OptionMetadata> options, String sectionHeader) throws IOException {
        writer.append(NEW_PARA).append(sectionHeader).append("OPTIONS");
        options = this.sortOptions(options);
        for (OptionMetadata option : options) {
            if (option.isHidden() && !this.includeHidden()) continue;
            writer.append(NEW_PARA).append("* ").append(this.toDescription(option)).append(":\n");
            writer.append(option.getDescription());
            if (option.getAllowedValues() == null || option.getAllowedValues().size() <= 0 || option.getArity() < 1) continue;
            this.outputAllowedValues(writer, option);
        }
        if (command.getArguments() != null) {
            writer.append(NEW_PARA).append("* `--`:\n");
            writer.append("This option can be used to separate command-line options from the list of arguments (useful when arguments might be mistaken for command-line options).");
            writer.append(NEW_PARA).append("* ").append(this.toDescription(command.getArguments())).append(":\n");
            writer.append(command.getArguments().getDescription());
        }
    }

    protected void outputAllowedValues(Writer writer, OptionMetadata option) throws IOException {
        writer.append(NEW_PARA).append("  This options value");
        if (option.getArity() == 1) {
            writer.append(" is ");
        } else {
            writer.append("s are ");
        }
        writer.append("restricted to the following value(s): [");
        boolean first = true;
        for (String value : option.getAllowedValues()) {
            if (first) {
                first = false;
            } else {
                writer.append(", ");
            }
            writer.append(value);
        }
        writer.append("]");
    }

    protected List<OptionMetadata> outputSynopsis(Writer writer, String programName, String groupName, String commandName, CommandMetadata command, String sectionHeader) throws IOException {
        List<OptionMetadata> aOptions;
        writer.append(NEW_PARA).append(sectionHeader).append("SYNOPSIS").append(NEW_PARA);
        ArrayList options = Lists.newArrayList();
        if (programName != null) {
            writer.append("`").append(programName).append("`");
            aOptions = command.getGlobalOptions();
            if (aOptions != null && aOptions.size() > 0) {
                writer.append(" ").append(Joiner.on((String)" ").join(this.toSynopsisUsage(this.sortOptions(aOptions))));
                options.addAll(aOptions);
            }
        }
        if (groupName != null) {
            writer.append(" `").append(groupName).append("`");
            aOptions = command.getGroupOptions();
            if (aOptions != null && aOptions.size() > 0) {
                writer.append(" ").append(Joiner.on((String)" ").join(this.toSynopsisUsage(this.sortOptions(aOptions))));
                options.addAll(aOptions);
            }
        }
        aOptions = command.getCommandOptions();
        writer.append(" `").append(commandName).append("` ").append(Joiner.on((String)" ").join(this.toSynopsisUsage(this.sortOptions(aOptions))));
        options.addAll(aOptions);
        if (command.getArguments() != null) {
            writer.append(" [--] ").append(this.toUsage(command.getArguments()));
        }
        if (!this.standalone) {
            writer.append(NEW_PARA).append(command.getDescription());
        }
        return options;
    }

    protected void outputExitCodes(Writer writer, String programName, String groupName, String commandName, CommandMetadata command, String sectionHeader) throws IOException {
        writer.append(NEW_PARA).append(sectionHeader).append("EXIT STATUS");
        writer.append(NEW_PARA).append("The `");
        this.writeFullCommandName(programName, groupName, commandName, writer);
        writer.append("` command exits with one of the following values:");
        writer.append(NEW_PARA);
        for (Map.Entry<Integer, String> exit : this.sortExitCodes(Lists.newArrayList(command.getExitCodes().entrySet()))) {
            writer.append("* **").append(exit.getKey().toString()).append("**");
            if (!StringUtils.isEmpty((CharSequence)exit.getValue())) {
                writer.append(" - ").append(exit.getValue());
            }
            writer.append('\n');
        }
    }

    protected void outputExamples(Writer writer, CommandMetadata command, String sectionHeader) throws IOException {
        writer.append(NEW_PARA).append(sectionHeader).append("EXAMPLES");
        for (String example : command.getExamples()) {
            writer.append(NEW_PARA).append(example);
        }
    }

    protected void outputDiscussion(Writer writer, CommandMetadata command, String sectionHeader) throws IOException {
        if (command.getDiscussion() == null || command.getDiscussion().isEmpty()) {
            return;
        }
        writer.append(NEW_PARA).append(sectionHeader).append("DISCUSSION").append(NEW_PARA);
        for (String discussionPara : command.getDiscussion()) {
            if (StringUtils.isEmpty((CharSequence)discussionPara)) continue;
            writer.append(discussionPara).append(NEW_PARA);
        }
    }

    protected String outputTitle(Writer writer, String programName, String groupName, String commandName, CommandMetadata command, String sectionHeader) throws IOException {
        if (!this.standalone) {
            writer.append(sectionHeader);
            sectionHeader = "#" + sectionHeader;
        }
        this.writeFullCommandName(programName, groupName, commandName, writer);
        if (this.standalone) {
            writer.append(" -- ");
            writer.append(command.getDescription()).append("\n");
            writer.append("==========");
        }
        return sectionHeader;
    }

    protected void writeFullCommandName(String programName, String groupName, String commandName, Writer writer) throws IOException {
        if (programName != null) {
            writer.append(programName).append("-");
        }
        if (groupName != null) {
            writer.append(groupName).append("-");
        }
        writer.append(commandName).append("(").append(Integer.toString(this.manSection)).append(")");
    }

    @Override
    protected String toDescription(OptionMetadata option) {
        Set<String> options = option.getOptions();
        StringBuilder stringBuilder = new StringBuilder();
        final String argumentString = option.getArity() > 0 ? Joiner.on((String)" ").join((Iterable)Lists.transform((List)ImmutableList.of((Object)option.getTitle()), (Function)new Function<String, String>(){

            public String apply(String argument) {
                return "<" + argument + ">";
            }
        })) : null;
        Joiner.on((String)", ").appendTo(stringBuilder, Iterables.transform(options, (Function)new Function<String, String>(){

            public String apply(String option) {
                if (argumentString != null) {
                    return "`" + option + "` " + argumentString;
                }
                return "`" + option + "`";
            }
        }));
        return stringBuilder.toString();
    }
}

