/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.io.colors;

import com.github.rvesse.airline.io.colors.AnsiColorProvider;
import com.google.common.base.Preconditions;

public class Color256
implements AnsiColorProvider {
    private final int color;

    public Color256(int color) {
        this.color = this.checkColor(color);
    }

    private int checkColor(int c) {
        Preconditions.checkArgument((c >= 0 && c <= 255 ? 1 : 0) != 0, (Object)String.format("Color was given value %d but only values in the range 0-255 are acceptable", c));
        return c;
    }

    @Override
    public String getAnsiForegroundControlCode() {
        return this.getAnsiColorCode(38);
    }

    @Override
    public String getAnsiBackgroundControlCode() {
        return this.getAnsiColorCode(48);
    }

    @Override
    public boolean usesExtendedColors() {
        return true;
    }

    private String getAnsiColorCode(int mode) {
        StringBuilder builder = new StringBuilder();
        builder.append("\u001b[").append(mode).append(';').append('5').append(';').append(this.color).append('m');
        return builder.toString();
    }

    public String toString() {
        return String.format("%d", this.color);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof Color256)) {
            return false;
        }
        Color256 c = (Color256)other;
        return this.color == c.color;
    }
}

