/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.io.colors;

import com.github.rvesse.airline.io.colors.AnsiColorProvider;
import com.google.common.base.Preconditions;

public class TrueColor
implements AnsiColorProvider {
    private final int r;
    private final int g;
    private final int b;

    public TrueColor(int red, int green, int blue) {
        this.r = this.checkColor(red, "red");
        this.g = this.checkColor(green, "green");
        this.b = this.checkColor(blue, "blue");
    }

    private int checkColor(int c, String argName) {
        Preconditions.checkArgument((c >= 0 && c <= 255 ? 1 : 0) != 0, (Object)String.format("%s component was given value %d but only values in the range 0-255 are acceptable", argName, c));
        return c;
    }

    @Override
    public String getAnsiForegroundControlCode() {
        return this.getAnsiColorCode(38);
    }

    @Override
    public String getAnsiBackgroundControlCode() {
        return this.getAnsiColorCode(48);
    }

    @Override
    public boolean usesExtendedColors() {
        return true;
    }

    private String getAnsiColorCode(int mode) {
        StringBuilder builder = new StringBuilder();
        builder.append("\u001b[").append(mode).append(';').append('2').append(';').append(this.r).append(';').append(this.g).append(';').append(this.b).append('m');
        return builder.toString();
    }

    public String toString() {
        return String.format("%d,%d,%d", this.r, this.g, this.b);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof TrueColor)) {
            return false;
        }
        TrueColor c = (TrueColor)other;
        return this.r == c.r && this.g == c.r && this.b == c.b;
    }
}

