/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.model;

import com.github.rvesse.airline.Accessor;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ArgumentsMetadata {
    private final List<String> titles;
    private final String description;
    private final String usage;
    private final String completionCommand;
    private final int completionBehaviour;
    private final boolean required;
    private final Set<Accessor> accessors;
    private final int arity;

    public ArgumentsMetadata(Iterable<String> titles, String description, String usage, boolean required, int arity, int completionBehaviour, String completionCommand, Iterable<Field> path) {
        Preconditions.checkNotNull(titles, (Object)"title is null");
        Preconditions.checkNotNull(path, (Object)"path is null");
        Preconditions.checkArgument((!Iterables.isEmpty(path) ? 1 : 0) != 0, (Object)"path is empty");
        this.titles = ImmutableList.copyOf(titles);
        this.description = description;
        this.usage = usage;
        this.required = required;
        this.arity = arity <= 0 ? Integer.MIN_VALUE : arity;
        this.completionBehaviour = completionBehaviour;
        this.completionCommand = completionCommand;
        this.accessors = ImmutableSet.of((Object)new Accessor(path));
    }

    public ArgumentsMetadata(Iterable<ArgumentsMetadata> arguments) {
        Preconditions.checkNotNull(arguments, (Object)"arguments is null");
        Preconditions.checkArgument((!Iterables.isEmpty(arguments) ? 1 : 0) != 0, (Object)"arguments is empty");
        ArgumentsMetadata first = arguments.iterator().next();
        this.titles = first.titles;
        this.description = first.description;
        this.usage = first.usage;
        this.required = first.required;
        this.arity = first.arity;
        this.completionBehaviour = first.completionBehaviour;
        this.completionCommand = first.completionCommand;
        HashSet accessors = Sets.newHashSet();
        for (ArgumentsMetadata other : arguments) {
            Preconditions.checkArgument((boolean)first.equals(other), (String)"Conflicting arguments definitions: %s, %s", (Object[])new Object[]{first, other});
            accessors.addAll(other.getAccessors());
        }
        this.accessors = ImmutableSet.copyOf((Collection)accessors);
    }

    public List<String> getTitle() {
        return this.titles;
    }

    public String getDescription() {
        return this.description;
    }

    public String getUsage() {
        return this.usage;
    }

    public boolean isRequired() {
        return this.required;
    }

    public int getArity() {
        return this.arity;
    }

    public int getCompletionBehaviours() {
        return this.completionBehaviour;
    }

    public String getCompletionCommand() {
        return this.completionCommand;
    }

    public Set<Accessor> getAccessors() {
        return this.accessors;
    }

    public boolean isMultiValued() {
        return this.accessors.iterator().next().isMultiValued();
    }

    public Class<?> getJavaType() {
        return this.accessors.iterator().next().getJavaType();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArgumentsMetadata that = (ArgumentsMetadata)o;
        if (this.required != that.required) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (!this.titles.equals(that.titles)) {
            return false;
        }
        return !(this.usage != null ? !this.usage.equals(that.usage) : that.usage != null);
    }

    public int hashCode() {
        int result = this.titles.hashCode();
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.usage != null ? this.usage.hashCode() : 0);
        result = 31 * result + (this.required ? 1 : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ArgumentsMetadata");
        sb.append("{title='").append(Joiner.on((char)',').join(this.titles)).append('\'');
        sb.append(", description='").append(this.description).append('\'');
        sb.append(", usage='").append(this.usage).append('\'');
        sb.append(", required=").append(this.required);
        sb.append(", accessors=").append(this.accessors);
        sb.append('}');
        return sb.toString();
    }
}

