/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.model;

import com.github.rvesse.airline.Accessor;
import com.github.rvesse.airline.OptionType;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public class OptionMetadata {
    private final OptionType optionType;
    private final Set<String> options;
    private final String title;
    private final String description;
    private final String completionCommand;
    private final int arity;
    private final int completionBehaviour;
    private final boolean required;
    private final boolean hidden;
    private final boolean overrides;
    private final boolean sealed;
    private final Set<String> allowedValues;
    private Set<Accessor> accessors;

    public OptionMetadata(OptionType optionType, Iterable<String> options, String title, String description, int arity, boolean required, boolean hidden, boolean overrides, boolean sealed, Iterable<String> allowedValues, int completionBehaviours, String completionCommand, Iterable<Field> path) {
        Preconditions.checkNotNull((Object)((Object)optionType), (Object)"optionType is null");
        Preconditions.checkNotNull(options, (Object)"options is null");
        Preconditions.checkArgument((!Iterables.isEmpty(options) ? 1 : 0) != 0, (Object)"options is empty");
        Preconditions.checkNotNull((Object)title, (Object)"title is null");
        this.optionType = optionType;
        this.options = ImmutableSet.copyOf(options);
        this.title = title;
        this.description = description;
        this.arity = arity;
        this.required = required;
        this.hidden = hidden;
        this.overrides = overrides;
        this.sealed = sealed;
        this.completionBehaviour = completionBehaviours;
        this.completionCommand = completionCommand;
        this.allowedValues = allowedValues != null ? ImmutableSet.copyOf(allowedValues) : null;
        if (path != null) {
            this.accessors = ImmutableSet.of((Object)new Accessor(path));
        }
    }

    public OptionMetadata(Iterable<OptionMetadata> options) {
        Preconditions.checkNotNull(options, (Object)"options is null");
        Preconditions.checkArgument((!Iterables.isEmpty(options) ? 1 : 0) != 0, (Object)"options is empty");
        Preconditions.checkArgument((boolean)options.iterator().hasNext());
        OptionMetadata option = options.iterator().next();
        this.optionType = option.optionType;
        this.options = option.options;
        this.title = option.title;
        this.description = option.description;
        this.arity = option.arity;
        this.required = option.required;
        this.hidden = option.hidden;
        this.overrides = option.overrides;
        this.sealed = option.sealed;
        this.allowedValues = option.allowedValues != null ? ImmutableSet.copyOf(option.allowedValues) : null;
        this.completionBehaviour = option.completionBehaviour;
        this.completionCommand = option.completionCommand;
        LinkedHashSet<Accessor> accessors = new LinkedHashSet<Accessor>();
        for (OptionMetadata other : options) {
            Preconditions.checkArgument((boolean)option.equals(other), (String)"Duplicate options definitions: %s, %s", (Object[])new Object[]{option, other});
            accessors.addAll(other.getAccessors());
        }
        this.accessors = ImmutableSet.copyOf(accessors);
    }

    public OptionType getOptionType() {
        return this.optionType;
    }

    public Set<String> getOptions() {
        return this.options;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public int getArity() {
        return this.arity;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isOverride() {
        return this.overrides;
    }

    public boolean isSealed() {
        return this.sealed;
    }

    public int getCompletionBehaviours() {
        return this.completionBehaviour;
    }

    public String getCompletionCommand() {
        return this.completionCommand;
    }

    public boolean isMultiValued() {
        return this.accessors.iterator().next().isMultiValued();
    }

    public Class<?> getJavaType() {
        return this.accessors.iterator().next().getJavaType();
    }

    public Set<Accessor> getAccessors() {
        if (this.accessors == null) {
            throw new NullPointerException("No accessors defined for option");
        }
        return this.accessors;
    }

    public Set<String> getAllowedValues() {
        return this.allowedValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OptionMetadata that = (OptionMetadata)o;
        if (this.arity != that.arity) {
            return false;
        }
        if (this.hidden != that.hidden) {
            return false;
        }
        if (this.required != that.required) {
            return false;
        }
        if (this.overrides != that.overrides) {
            return false;
        }
        if (this.sealed != that.sealed) {
            return false;
        }
        if (this.allowedValues != null ? !this.allowedValues.equals(that.allowedValues) : that.allowedValues != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.optionType != that.optionType) {
            return false;
        }
        if (!this.options.equals(that.options)) {
            return false;
        }
        return this.title.equals(that.title);
    }

    public int hashCode() {
        int result = this.optionType.hashCode();
        result = 31 * result + this.options.hashCode();
        result = 31 * result + this.title.hashCode();
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + this.arity;
        result = 31 * result + (this.required ? 1 : 0);
        result = 31 * result + (this.hidden ? 1 : 0);
        result = 31 * result + (this.overrides ? 1 : 0);
        result = 31 * result + (this.sealed ? 1 : 0);
        result = 31 * result + (this.allowedValues != null ? this.allowedValues.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("OptionMetadata");
        sb.append("{optionType=").append((Object)this.optionType);
        sb.append(", options=").append(this.options);
        sb.append(", title='").append(this.title).append('\'');
        sb.append(", description='").append(this.description).append('\'');
        sb.append(", arity=").append(this.arity);
        sb.append(", required=").append(this.required);
        sb.append(", hidden=").append(this.hidden);
        sb.append(", override=").append(this.overrides);
        sb.append(", sealed=").append(this.sealed);
        sb.append(", allowedValues=");
        if (this.allowedValues != null) {
            sb.append("{");
            Iterator<String> iter = this.allowedValues.iterator();
            while (iter.hasNext()) {
                sb.append("'").append(iter.next()).append("'");
                if (!iter.hasNext()) continue;
                sb.append(", ");
            }
            sb.append("}");
        } else {
            sb.append("{}");
        }
        sb.append(", accessors=").append(this.accessors);
        sb.append('}');
        return sb.toString();
    }

    public static OptionMetadata override(Set<String> names, OptionMetadata parent, OptionMetadata child) {
        boolean isDuplicate;
        Class<?> childType;
        if (parent.optionType != child.optionType) {
            throw new IllegalArgumentException(String.format("Cannot change optionType when overriding option %s", names));
        }
        if (parent.arity != child.arity) {
            throw new IllegalArgumentException(String.format("Cannot change arity when overriding option %s", names));
        }
        if (!parent.options.equals(child.options)) {
            throw new IllegalArgumentException(String.format("Cannot change option names when overriding option %s", names));
        }
        Class<?> parentType = parent.getJavaType();
        if (!parentType.equals(childType = child.getJavaType()) && !parentType.isAssignableFrom(childType)) {
            if (childType.isAssignableFrom(parentType)) {
                throw new IllegalArgumentException(String.format("Cannot change the Java type from %s to %s when overriding option %s as this is a widening type change - only narrowing type changes are permitted", parentType, childType, names));
            }
            throw new IllegalArgumentException(String.format("Cannot change the Java type from %s to %s when overriding option %s - only narrowing type changes where a valid cast exists are permitted", parentType, childType, names));
        }
        boolean bl = isDuplicate = parent == child || parent.equals(child);
        if (parent.sealed && !isDuplicate) {
            throw new IllegalArgumentException(String.format("Cannot override option %s as parent option declares it to be sealed", names));
        }
        if (!child.overrides && !isDuplicate) {
            throw new IllegalArgumentException(String.format("Cannot override option %s unless child option sets overrides to true", names));
        }
        OptionMetadata merged = new OptionMetadata(child.optionType, child.options, child.title != null ? child.title : parent.title, child.description != null ? child.description : parent.description, child.arity, child.required, child.hidden, child.overrides, child.sealed, child.allowedValues != null ? child.allowedValues : parent.allowedValues, child.completionBehaviour, child.completionCommand, null);
        LinkedHashSet<Accessor> accessors = new LinkedHashSet<Accessor>(child.accessors);
        accessors.addAll(parent.accessors);
        merged.accessors = ImmutableSet.copyOf(accessors);
        return merged;
    }

    public static Function<OptionMetadata, Set<String>> optionsGetter() {
        return new Function<OptionMetadata, Set<String>>(){

            public Set<String> apply(OptionMetadata input) {
                return input.getOptions();
            }
        };
    }

    public static Predicate<OptionMetadata> isHiddenPredicate() {
        return new Predicate<OptionMetadata>(){

            public boolean apply(OptionMetadata input) {
                return !input.isHidden();
            }
        };
    }
}

