/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.parser;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class AbstractAbbreviationFinder<T>
implements Predicate<T> {
    private List<T> candidates = new ArrayList<T>();
    private T exact = null;

    public AbstractAbbreviationFinder(String value, Collection<T> items) {
        this.candidates.addAll(items);
        for (int i = 0; i < this.candidates.size(); ++i) {
            T item = this.candidates.get(i);
            if (this.isExactNameMatch(value, item)) {
                this.exact = item;
                continue;
            }
            if (this.isPartialNameMatch(value, item)) continue;
            this.candidates.remove(i);
            --i;
        }
    }

    protected abstract boolean isExactNameMatch(String var1, T var2);

    protected abstract boolean isPartialNameMatch(String var1, T var2);

    public final boolean apply(T item) {
        return this.isExact(item) || this.isAbbreviation(item);
    }

    private boolean isExact(T item) {
        return this.exact != null && this.exact.equals(item);
    }

    private boolean isAbbreviation(T item) {
        return this.candidates.size() == 1 && this.candidates.contains(item);
    }
}

