/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.parser;

import com.github.rvesse.airline.parser.ParseException;
import com.google.common.collect.ImmutableSet;
import java.util.Set;

public class ParseOptionIllegalValueException
extends ParseException {
    private static final long serialVersionUID = 810812151673279427L;
    private final String optionTitle;
    private final String illegalValue;
    private final Set<String> allowedValues;

    public ParseOptionIllegalValueException(String optionTitle, String value, Set<String> allowedValues) {
        super("Value for option '%s' was given as '%s' which is not in the list of allowed values: %s", optionTitle, value, allowedValues);
        this.optionTitle = optionTitle;
        this.illegalValue = value;
        this.allowedValues = ImmutableSet.copyOf(allowedValues);
    }

    public String getOptionTitle() {
        return this.optionTitle;
    }

    public String getIllegalValue() {
        return this.illegalValue;
    }

    public Set<String> getAllowedValues() {
        return this.allowedValues;
    }
}

