/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline;

import com.github.rvesse.airline.TypeConverter;
import com.github.rvesse.airline.parser.errors.ParseOptionConversionException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public class DefaultTypeConverter
implements TypeConverter {
    @Override
    public Object convert(String name, Class<?> type, String value) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        ConvertResult result = this.tryConvertBasicTypes(type, value);
        if (result.wasSuccessfull()) {
            return result.getConvertedValue();
        }
        result = this.tryConvertFromString(type, value);
        if (result.wasSuccessfull()) {
            return result.getConvertedValue();
        }
        result = this.tryConvertFromValueOf(type, value);
        if (result.wasSuccessfull()) {
            return result.getConvertedValue();
        }
        result = this.tryConvertStringConstructor(type, value);
        if (result.wasSuccessfull()) {
            return result.getConvertedValue();
        }
        throw new ParseOptionConversionException(name, value, type.getSimpleName());
    }

    protected final ConvertResult tryConvertStringConstructor(Class<?> type, String value) {
        try {
            Constructor<?> constructor = type.getConstructor(String.class);
            return new ConvertResult(constructor.newInstance(value));
        }
        catch (Throwable throwable) {
            return ConvertResult.FAILURE;
        }
    }

    protected final ConvertResult tryConvertFromValueOf(Class<?> type, String value) {
        return this.tryConvertStringMethod(type, value, "valueOf");
    }

    protected final ConvertResult tryConvertFromString(Class<?> type, String value) {
        return this.tryConvertStringMethod(type, value, "fromString");
    }

    protected final ConvertResult tryConvertStringMethod(Class<?> type, String value, String methodName) {
        try {
            Method method = type.getMethod(methodName, String.class);
            if (method.getReturnType().isAssignableFrom(type)) {
                return new ConvertResult(method.invoke(null, value));
            }
        }
        catch (Throwable ignored) {
            // empty catch block
        }
        return ConvertResult.FAILURE;
    }

    protected final ConvertResult tryConvertBasicTypes(Class<?> type, String value) {
        try {
            if (String.class.isAssignableFrom(type)) {
                return new ConvertResult(value);
            }
            if (Boolean.class.isAssignableFrom(type) || Boolean.TYPE.isAssignableFrom(type)) {
                return new ConvertResult(Boolean.valueOf(value));
            }
            if (Byte.class.isAssignableFrom(type) || Byte.TYPE.isAssignableFrom(type)) {
                return new ConvertResult(Byte.valueOf(value));
            }
            if (Short.class.isAssignableFrom(type) || Short.TYPE.isAssignableFrom(type)) {
                return new ConvertResult(Short.valueOf(value));
            }
            if (Integer.class.isAssignableFrom(type) || Integer.TYPE.isAssignableFrom(type)) {
                return new ConvertResult(Integer.valueOf(value));
            }
            if (Long.class.isAssignableFrom(type) || Long.TYPE.isAssignableFrom(type)) {
                return new ConvertResult(Long.valueOf(value));
            }
            if (Float.class.isAssignableFrom(type) || Float.TYPE.isAssignableFrom(type)) {
                return new ConvertResult(Float.valueOf(value));
            }
            if (Double.class.isAssignableFrom(type) || Double.TYPE.isAssignableFrom(type)) {
                return new ConvertResult(Double.valueOf(value));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ConvertResult.FAILURE;
    }

    private static class ConvertResult {
        private final Object value;
        private final boolean success;
        public static final ConvertResult FAILURE = new ConvertResult();

        private ConvertResult() {
            this.value = null;
            this.success = false;
        }

        public ConvertResult(Object value) {
            this.value = value;
            this.success = true;
        }

        public boolean wasSuccessfull() {
            return this.success;
        }

        public Object getConvertedValue() {
            return this.value;
        }
    }
}

